/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.quarkus.rest.client.reactive.runtime.BeanGrabber;
import io.quarkus.rest.client.reactive.runtime.RestClientBuilderImpl;
import io.quarkus.rest.client.reactive.runtime.context.ClientHeadersFactoryContextResolver;
import io.quarkus.rest.client.reactive.runtime.context.HttpClientOptionsContextResolver;
import io.vertx.core.http.HttpClientOptions;
import jakarta.ws.rs.core.Configuration;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class QuarkusRestClientBuilderImpl
implements QuarkusRestClientBuilder {
    private final RestClientBuilderImpl proxy;

    public QuarkusRestClientBuilderImpl(RestClientBuilderImpl proxy) {
        this.proxy = proxy;
    }

    @Override
    public QuarkusRestClientBuilder baseUrl(URL url) {
        this.proxy.baseUrl(url);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder baseUri(URI uri) {
        this.proxy.baseUri(uri);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.proxy.connectTimeout(timeout, unit);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.proxy.readTimeout(timeout, unit);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder sslContext(SSLContext sslContext) {
        this.proxy.sslContext(sslContext);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder verifyHost(boolean verifyHost) {
        this.proxy.verifyHost(verifyHost);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder trustStore(KeyStore trustStore) {
        this.proxy.trustStore(trustStore);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder trustStore(KeyStore trustStore, String trustStorePassword) {
        this.proxy.trustStore(trustStore, trustStorePassword);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder keyStore(KeyStore keyStore, String keystorePassword) {
        this.proxy.keyStore(keyStore, keystorePassword);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.proxy.hostnameVerifier(hostnameVerifier);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder followRedirects(boolean follow) {
        this.proxy.followRedirects(follow);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyAddress(String proxyHost, int proxyPort) {
        this.proxy.proxyAddress(proxyHost, proxyPort);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyPassword(String proxyPassword) {
        this.proxy.proxyPassword(proxyPassword);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyUser(String proxyUser) {
        this.proxy.proxyUser(proxyUser);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder nonProxyHosts(String nonProxyHosts) {
        this.proxy.nonProxyHosts(nonProxyHosts);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder multipartPostEncoderMode(String mode) {
        this.proxy.multipartPostEncoderMode(mode);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder queryParamStyle(QueryParamStyle style) {
        this.proxy.queryParamStyle(style);
        return this;
    }

    public Configuration getConfiguration() {
        return this.proxy.getConfiguration();
    }

    public QuarkusRestClientBuilder property(String name, Object value) {
        this.proxy.property(name, value);
        return this;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass) {
        this.proxy.register(componentClass);
        return this;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass, int priority) {
        this.proxy.register(componentClass, priority);
        return this;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.proxy.register(componentClass, contracts);
        return null;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.proxy.register(componentClass, contracts);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component) {
        this.proxy.register(component);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component, int priority) {
        this.proxy.register(component, priority);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component, Class<?> ... contracts) {
        this.proxy.register(component, contracts);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.proxy.register(component, contracts);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder clientHeadersFactory(Class<? extends ClientHeadersFactory> clientHeadersFactoryClass) {
        ClientHeadersFactory bean = BeanGrabber.getBeanIfDefined(clientHeadersFactoryClass);
        if (bean == null) {
            throw new IllegalArgumentException("Failed to instantiate the client headers factory " + clientHeadersFactoryClass + ". Make sure the bean is properly configured for CDI injection.");
        }
        return this.clientHeadersFactory(bean);
    }

    @Override
    public QuarkusRestClientBuilder clientHeadersFactory(ClientHeadersFactory clientHeadersFactory) {
        this.proxy.register(new ClientHeadersFactoryContextResolver(clientHeadersFactory));
        return this;
    }

    @Override
    public QuarkusRestClientBuilder httpClientOptions(Class<? extends HttpClientOptions> httpClientOptionsClass) {
        HttpClientOptions bean = BeanGrabber.getBeanIfDefined(httpClientOptionsClass);
        if (bean == null) {
            throw new IllegalArgumentException("Failed to instantiate the HTTP client options " + httpClientOptionsClass + ". Make sure the bean is properly configured for CDI injection.");
        }
        return this.httpClientOptions(bean);
    }

    @Override
    public QuarkusRestClientBuilder httpClientOptions(HttpClientOptions httpClientOptions) {
        this.proxy.register(new HttpClientOptionsContextResolver(httpClientOptions));
        return this;
    }

    @Override
    public QuarkusRestClientBuilder clientLogger(ClientLogger clientLogger) {
        this.proxy.clientLogger(clientLogger);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder loggingScope(LoggingScope loggingScope) {
        this.proxy.loggingScope(loggingScope);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder loggingBodyLimit(Integer limit) {
        this.proxy.loggingBodyLimit(limit);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder trustAll(boolean trustAll) {
        this.proxy.trustAll(trustAll);
        return this;
    }

    @Override
    public <T> T build(Class<T> clazz) throws IllegalStateException, RestClientDefinitionException {
        return this.proxy.build(clazz);
    }
}

