/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ParameterDescriptorFromClassSupplier
implements Supplier<Map<String, ParameterDescriptor>> {
    private final Class clazz;
    private volatile Map<String, ParameterDescriptor> value;

    public ParameterDescriptorFromClassSupplier(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public Map<String, ParameterDescriptor> get() {
        if (this.value == null) {
            this.value = new HashMap<String, ParameterDescriptor>();
            for (Class currentClass = this.clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                ParameterDescriptor descriptor;
                for (Field field : currentClass.getDeclaredFields()) {
                    descriptor = new ParameterDescriptor();
                    descriptor.annotations = field.getAnnotations();
                    descriptor.genericType = field.getGenericType();
                    this.value.put(field.getName(), descriptor);
                }
                for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                    descriptor = new ParameterDescriptor();
                    descriptor.annotations = accessibleObject.getAnnotations();
                    descriptor.genericType = ((Method)accessibleObject).getGenericReturnType();
                    this.value.put(((Method)accessibleObject).getName(), descriptor);
                }
            }
        }
        return this.value;
    }

    public static class ParameterDescriptor {
        public Annotation[] annotations;
        public Type genericType;
    }
}

