/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.devui.Name;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.reactive.datasource.deployment.ReactiveDataSourceBuildUtil;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.mysql.client.MySQLPoolCreator;
import io.quarkus.reactive.mysql.client.deployment.MySQLPoolBuildItem;
import io.quarkus.reactive.mysql.client.runtime.DataSourcesReactiveMySQLConfig;
import io.quarkus.reactive.mysql.client.runtime.MySQLPoolRecorder;
import io.quarkus.reactive.mysql.client.runtime.MySQLServiceBindingConverter;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.Pool;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

class ReactiveMySQLClientProcessor {
    private static final ParameterizedType POOL_CREATOR_INJECTION_TYPE = ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)MySQLPoolCreator.class.getName()))}, null);
    private static final DotName VERTX_MYSQL_POOL = DotName.createSimple(MySQLPool.class);
    private static final Type VERTX_MYSQL_POOL_TYPE = Type.create((DotName)VERTX_MYSQL_POOL, (Type.Kind)Type.Kind.CLASS);

    ReactiveMySQLClientProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem build(BuildProducer<FeatureBuildItem> feature, BuildProducer<MySQLPoolBuildItem> mySQLPool, BuildProducer<VertxPoolBuildItem> vertxPool, MySQLPoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMySQLConfig dataSourcesReactiveMySQLConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REACTIVE_MYSQL_CLIENT));
        for (String dataSourceName : dataSourcesBuildTimeConfig.dataSources().keySet()) {
            this.createPoolIfDefined(recorder, vertx, eventLoopCount, shutdown, mySQLPool, syntheticBeans, dataSourceName, dataSourcesBuildTimeConfig, dataSourcesRuntimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMySQLConfig, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem);
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.REACTIVE_MYSQL_CLIENT));
        vertxPool.produce((BuildItem)new VertxPoolBuildItem());
        return new ServiceStartBuildItem("reactive-mysql-client");
    }

    @BuildStep
    List<DevServicesDatasourceConfigurationHandlerBuildItem> devDbHandler() {
        return List.of(DevServicesDatasourceConfigurationHandlerBuildItem.reactive((String)"mysql"), DevServicesDatasourceConfigurationHandlerBuildItem.reactive((String)"mariadb"));
    }

    @BuildStep
    void unremoveableBeans(BuildProducer<UnremovableBeanBuildItem> producer) {
        producer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{MySQLPoolCreator.class}));
    }

    @BuildStep
    void validateBeans(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        HashMap<String, Boolean> seen = new HashMap<String, Boolean>();
        for (BeanInfo beanInfo : validationPhase.getContext().beans().matchBeanTypes((Predicate)new MySQLPoolCreatorBeanClassPredicate())) {
            TreeSet<Name> qualifiers = new TreeSet<Name>();
            for (AnnotationInstance qualifier : beanInfo.getQualifiers()) {
                qualifiers.add(Name.from((AnnotationInstance)qualifier));
            }
            String qualifiersStr = qualifiers.stream().map(Name::toString).collect(Collectors.joining("_"));
            if (seen.getOrDefault(qualifiersStr, false).booleanValue()) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("There can be at most one bean of type '" + MySQLPoolCreator.class.getName() + "' for each datasource.")}));
                continue;
            }
            seen.put(qualifiersStr, true);
        }
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{MySQLServiceBindingConverter.class.getName()}));
        }
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("mysql"));
    }

    @BuildStep
    void addHealthCheck(Capabilities capabilities, BuildProducer<HealthBuildItem> healthChecks, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!capabilities.isPresent("io.quarkus.smallrye.health")) {
            return;
        }
        if (!this.hasPools(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return;
        }
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.reactive.mysql.client.runtime.health.ReactiveMySQLDataSourcesHealthCheck", dataSourcesBuildTimeConfig.healthEnabled()));
    }

    private void createPoolIfDefined(MySQLPoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<MySQLPoolBuildItem> mySQLPool, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, String dataSourceName, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMySQLConfig dataSourcesReactiveMySQLConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!ReactiveMySQLClientProcessor.isReactiveMySQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return;
        }
        Function poolFunction = recorder.configureMySQLPool(vertx.getVertx(), eventLoopCount.getEventLoopCount(), dataSourceName, dataSourcesRuntimeConfig, dataSourcesReactiveRuntimeConfig, dataSourcesReactiveMySQLConfig, (ShutdownContext)shutdown);
        mySQLPool.produce((BuildItem)new MySQLPoolBuildItem(dataSourceName, poolFunction));
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mySQLPoolBeanConfigurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MySQLPool.class).defaultBean()).addType(Pool.class)).scope(ApplicationScoped.class)).qualifiers(ReactiveDataSourceBuildUtil.qualifiers((String)dataSourceName))).addInjectionPoint((Type)POOL_CREATOR_INJECTION_TYPE, new AnnotationInstance[]{ReactiveDataSourceBuildUtil.qualifier((String)dataSourceName)})).checkActive(recorder.poolCheckActiveSupplier(dataSourceName)).createWith(poolFunction).unremovable()).setRuntimeInit().startup();
        syntheticBeans.produce((BuildItem)mySQLPoolBeanConfigurator.done());
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mutinyMySQLPoolConfigurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mutiny.mysqlclient.MySQLPool.class).defaultBean()).addType(io.vertx.mutiny.sqlclient.Pool.class)).scope(ApplicationScoped.class)).qualifiers(ReactiveDataSourceBuildUtil.qualifiers((String)dataSourceName))).addInjectionPoint(VERTX_MYSQL_POOL_TYPE, new AnnotationInstance[]{ReactiveDataSourceBuildUtil.qualifier((String)dataSourceName)})).checkActive(recorder.poolCheckActiveSupplier(dataSourceName)).createWith(recorder.mutinyMySQLPool(dataSourceName)).unremovable()).setRuntimeInit().startup();
        syntheticBeans.produce((BuildItem)mutinyMySQLPoolConfigurator.done());
    }

    private static boolean isReactiveMySQLPoolDefined(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, String dataSourceName, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = (DataSourceBuildTimeConfig)dataSourcesBuildTimeConfig.dataSources().get(dataSourceName);
        DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig = ((DataSourcesReactiveBuildTimeConfig.DataSourceReactiveOuterNamedBuildTimeConfig)dataSourcesReactiveBuildTimeConfig.dataSources().get(dataSourceName)).reactive();
        Optional dbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind(), defaultDataSourceDbKindBuildItems, (!DataSourceUtil.isDefault((String)dataSourceName) || dataSourceBuildTimeConfig.devservices().enabled().orElse(!dataSourcesBuildTimeConfig.hasNamedDataSources()) != false ? 1 : 0) != 0, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (!dbKind.isPresent()) {
            return false;
        }
        return (DatabaseKind.isMySQL((String)((String)dbKind.get())) || DatabaseKind.isMariaDB((String)((String)dbKind.get()))) && dataSourceReactiveBuildTimeConfig.enabled();
    }

    private boolean hasPools(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (ReactiveMySQLClientProcessor.isReactiveMySQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, "<default>", defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return true;
        }
        for (String dataSourceName : dataSourcesBuildTimeConfig.dataSources().keySet()) {
            if (!ReactiveMySQLClientProcessor.isReactiveMySQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) continue;
            return true;
        }
        return false;
    }

    private static class MySQLPoolCreatorBeanClassPredicate
    implements Predicate<Set<Type>> {
        private static final Type MYSQL_POOL_CREATOR = Type.create((DotName)DotName.createSimple((String)MySQLPoolCreator.class.getName()), (Type.Kind)Type.Kind.CLASS);

        private MySQLPoolCreatorBeanClassPredicate() {
        }

        @Override
        public boolean test(Set<Type> types) {
            return types.contains(MYSQL_POOL_CREATOR);
        }
    }
}

