/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mssql.client.runtime;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ConnectOptionsSupplier;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.reactive.datasource.runtime.UnitisedTime;
import io.quarkus.reactive.mssql.client.MSSQLPoolCreator;
import io.quarkus.reactive.mssql.client.runtime.DataSourceReactiveMSSQLConfig;
import io.quarkus.reactive.mssql.client.runtime.DataSourcesReactiveMSSQLConfig;
import io.quarkus.reactive.mssql.client.runtime.MSSQLPoolSupport;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.mssqlclient.spi.MSSQLDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Utils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class MSSQLPoolRecorder {
    private static final TypeLiteral<Instance<MSSQLPoolCreator>> POOL_CREATOR_TYPE_LITERAL = new TypeLiteral<Instance<MSSQLPoolCreator>>(){};
    private static final Logger log = Logger.getLogger(MSSQLPoolRecorder.class);
    private final RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig;
    private final RuntimeValue<DataSourcesReactiveRuntimeConfig> reactiveRuntimeConfig;
    private final RuntimeValue<DataSourcesReactiveMSSQLConfig> reactiveMSSQLRuntimeConfig;

    public MSSQLPoolRecorder(RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig, RuntimeValue<DataSourcesReactiveRuntimeConfig> reactiveRuntimeConfig, RuntimeValue<DataSourcesReactiveMSSQLConfig> reactiveMSSQLRuntimeConfig) {
        this.runtimeConfig = runtimeConfig;
        this.reactiveRuntimeConfig = reactiveRuntimeConfig;
        this.reactiveMSSQLRuntimeConfig = reactiveMSSQLRuntimeConfig;
    }

    public Supplier<ActiveResult> poolCheckActiveSupplier(final String dataSourceName) {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                Optional active = ((DataSourceRuntimeConfig)((DataSourcesRuntimeConfig)MSSQLPoolRecorder.this.runtimeConfig.getValue()).dataSources().get(dataSourceName)).active();
                if (active.isPresent() && !((Boolean)active.get()).booleanValue()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonDeactivated((String)dataSourceName));
                }
                if (((DataSourcesReactiveRuntimeConfig.DataSourceReactiveOuterNamedRuntimeConfig)((DataSourcesReactiveRuntimeConfig)MSSQLPoolRecorder.this.reactiveRuntimeConfig.getValue()).dataSources().get(dataSourceName)).reactive().url().isEmpty()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonUrlMissing((String)dataSourceName, (String)"reactive.url"));
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<MSSQLPool>, MSSQLPool> configureMSSQLPool(final RuntimeValue<Vertx> vertx, final Supplier<Integer> eventLoopCount, final String dataSourceName, final ShutdownContext shutdown) {
        return new Function<SyntheticCreationalContext<MSSQLPool>, MSSQLPool>(){

            @Override
            public MSSQLPool apply(SyntheticCreationalContext<MSSQLPool> context) {
                MSSQLPool pool = MSSQLPoolRecorder.this.initialize((VertxInternal)vertx.getValue(), (Integer)eventLoopCount.get(), dataSourceName, (DataSourceRuntimeConfig)((DataSourcesRuntimeConfig)MSSQLPoolRecorder.this.runtimeConfig.getValue()).dataSources().get(dataSourceName), ((DataSourcesReactiveRuntimeConfig.DataSourceReactiveOuterNamedRuntimeConfig)((DataSourcesReactiveRuntimeConfig)MSSQLPoolRecorder.this.reactiveRuntimeConfig.getValue()).dataSources().get(dataSourceName)).reactive(), ((DataSourcesReactiveMSSQLConfig)MSSQLPoolRecorder.this.reactiveMSSQLRuntimeConfig.getValue()).dataSources().get(dataSourceName).reactive().mssql(), context);
                shutdown.addShutdownTask(() -> ((MSSQLPool)pool).close());
                return pool;
            }
        };
    }

    public Function<SyntheticCreationalContext<io.vertx.mutiny.mssqlclient.MSSQLPool>, io.vertx.mutiny.mssqlclient.MSSQLPool> mutinyMSSQLPool(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<io.vertx.mutiny.mssqlclient.MSSQLPool>, io.vertx.mutiny.mssqlclient.MSSQLPool>(){

            @Override
            public io.vertx.mutiny.mssqlclient.MSSQLPool apply(SyntheticCreationalContext context) {
                return io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((MSSQLPool)((MSSQLPool)context.getInjectedReference(MSSQLPool.class, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)})));
            }
        };
    }

    private MSSQLPool initialize(VertxInternal vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig, SyntheticCreationalContext<MSSQLPool> context) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceReactiveRuntimeConfig);
        MSSQLConnectOptions mssqlConnectOptions = this.toMSSQLConnectOptions(dataSourceName, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMSSQLConfig);
        Supplier<Future<MSSQLConnectOptions>> databasesSupplier = this.toDatabasesSupplier((Vertx)vertx, List.of(mssqlConnectOptions), dataSourceRuntimeConfig);
        return this.createPool((Vertx)vertx, poolOptions, mssqlConnectOptions, dataSourceName, databasesSupplier, context);
    }

    private Supplier<Future<MSSQLConnectOptions>> toDatabasesSupplier(Vertx vertx, List<MSSQLConnectOptions> mssqlConnectOptionsList, DataSourceRuntimeConfig dataSourceRuntimeConfig) {
        Supplier supplier;
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            supplier = new ConnectOptionsSupplier(vertx, credentialsProvider, name, mssqlConnectOptionsList, MSSQLConnectOptions::new);
        } else {
            supplier = Utils.roundRobinSupplier(mssqlConnectOptionsList);
        }
        return supplier;
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize());
        if (dataSourceReactiveRuntimeConfig.idleTimeout().isPresent()) {
            UnitisedTime idleTimeout = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.idleTimeout().get()));
            poolOptions.setIdleTimeout(idleTimeout.value).setIdleTimeoutUnit(idleTimeout.unit);
        }
        if (dataSourceReactiveRuntimeConfig.maxLifetime().isPresent()) {
            UnitisedTime maxLifetime = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.maxLifetime().get()));
            poolOptions.setMaxLifetime(maxLifetime.value).setMaxLifetimeUnit(maxLifetime.unit);
        }
        if (dataSourceReactiveRuntimeConfig.shared()) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name().isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name().get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize().isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize().getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private MSSQLConnectOptions toMSSQLConnectOptions(String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig) {
        MSSQLConnectOptions mssqlConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url().isPresent()) {
            String url;
            List urls = (List)dataSourceReactiveRuntimeConfig.url().get();
            if (urls.size() > 1) {
                log.warn((Object)"The Reactive MSSQL client does not support multiple URLs. The first one will be used, and others will be ignored.");
            }
            if ((url = (String)urls.get(0)).startsWith("vertx-reactive:sqlserver://")) {
                url = url.substring("vertx-reactive:".length());
            }
            mssqlConnectOptions = MSSQLConnectOptions.fromUri((String)url);
        } else {
            mssqlConnectOptions = new MSSQLConnectOptions();
        }
        if (dataSourceReactiveMSSQLConfig.packetSize().isPresent()) {
            mssqlConnectOptions.setPacketSize(dataSourceReactiveMSSQLConfig.packetSize().getAsInt());
        }
        if (dataSourceRuntimeConfig.username().isPresent()) {
            mssqlConnectOptions.setUser((String)dataSourceRuntimeConfig.username().get());
        }
        if (dataSourceRuntimeConfig.password().isPresent()) {
            mssqlConnectOptions.setPassword((String)dataSourceRuntimeConfig.password().get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                mssqlConnectOptions.setUser(user);
            }
            if (password != null) {
                mssqlConnectOptions.setPassword(password);
            }
        }
        mssqlConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts());
        mssqlConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval().toMillis());
        mssqlConnectOptions.setSsl(dataSourceReactiveMSSQLConfig.ssl());
        mssqlConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll());
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)mssqlConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem());
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)mssqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks());
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)mssqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx());
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem());
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks());
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx());
        String algo = dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm();
        if ("NONE".equalsIgnoreCase(algo)) {
            mssqlConnectOptions.setHostnameVerificationAlgorithm("");
        } else {
            mssqlConnectOptions.setHostnameVerificationAlgorithm(algo);
        }
        dataSourceReactiveRuntimeConfig.additionalProperties().forEach((arg_0, arg_1) -> ((MSSQLConnectOptions)mssqlConnectOptions).addProperty(arg_0, arg_1));
        mssqlConnectOptions.setMetricsName("mssql|" + dataSourceName);
        return mssqlConnectOptions;
    }

    private MSSQLPool createPool(Vertx vertx, PoolOptions poolOptions, MSSQLConnectOptions mSSQLConnectOptions, String dataSourceName, Supplier<Future<MSSQLConnectOptions>> databases, SyntheticCreationalContext<MSSQLPool> context) {
        Instance instance = (Instance)context.getInjectedReference(POOL_CREATOR_TYPE_LITERAL, new Annotation[]{ReactiveDataSourceUtil.qualifier((String)dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, mSSQLConnectOptions);
            return (MSSQLPool)((MSSQLPoolCreator)instance.get()).create(input);
        }
        return (MSSQLPool)MSSQLDriver.INSTANCE.createPool(vertx, databases, poolOptions);
    }

    public RuntimeValue<MSSQLPoolSupport> createMSSQLPoolSupport(Set<String> msSQLPoolNames) {
        return new RuntimeValue((Object)new MSSQLPoolSupport(msSQLPoolNames));
    }

    private static class DefaultInput
    implements MSSQLPoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final MSSQLConnectOptions mSSQLConnectOptions;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, MSSQLConnectOptions mSSQLConnectOptions) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.mSSQLConnectOptions = mSSQLConnectOptions;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public MSSQLConnectOptions msSQLConnectOptions() {
            return this.mSSQLConnectOptions;
        }
    }
}

