/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.db2.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.reactive.datasource.runtime.ReactiveDatasourceHealthCheck;
import io.quarkus.reactive.db2.client.runtime.DB2PoolSupport;
import io.vertx.sqlclient.Pool;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class ReactiveDB2DataSourcesHealthCheck
extends ReactiveDatasourceHealthCheck {
    public ReactiveDB2DataSourcesHealthCheck() {
        super("Reactive DB2 connections health check", "SELECT 1 FROM SYSIBM.SYSDUMMY1");
    }

    @PostConstruct
    protected void init() {
        ArcContainer container = Arc.container();
        DataSourceSupport dataSourceSupport = (DataSourceSupport)container.instance(DataSourceSupport.class, new Annotation[0]).get();
        Set excludedNames = dataSourceSupport.getHealthCheckExcludedNames();
        DB2PoolSupport db2PoolSupport = (DB2PoolSupport)container.instance(DB2PoolSupport.class, new Annotation[0]).get();
        Set<String> db2PoolNames = db2PoolSupport.getDB2PoolNames();
        for (InstanceHandle handle : container.select(Pool.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            String poolName;
            if (!handle.getBean().isActive() || !db2PoolNames.contains(poolName = ReactiveDataSourceUtil.dataSourceName((Bean)handle.getBean())) || excludedNames.contains(poolName)) continue;
            this.addPool(poolName, (Pool)handle.get());
        }
    }
}

