/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.common.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.oidc.token.propagation.common.AccessToken;
import io.quarkus.oidc.token.propagation.common.deployment.AccessTokenInstanceBuildItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class OidcTokenPropagationCommonProcessor {
    private static final DotName ACCESS_TOKEN = DotName.createSimple((String)AccessToken.class.getName());

    @BuildStep
    public List<AccessTokenInstanceBuildItem> collectAccessTokenInstances(CombinedIndexBuildItem index) {
        Collection accessTokenAnnotations = index.getIndex().getAnnotations(ACCESS_TOKEN);
        record ItemBuilder(AnnotationInstance instance) {
            private String toClientName() {
                AnnotationValue value = this.instance.value("exchangeTokenClient");
                return value == null || value.asString().equals("Default") ? "" : value.asString();
            }

            private boolean toExchangeToken() {
                return this.instance.value("exchangeTokenClient") != null;
            }

            private MethodInfo methodInfo() {
                if (this.instance.target().kind() == AnnotationTarget.Kind.METHOD) {
                    return this.instance.target().asMethod();
                }
                return null;
            }

            private String targetClassName() {
                if (this.instance.target().kind() == AnnotationTarget.Kind.METHOD) {
                    return this.instance.target().asMethod().declaringClass().name().toString();
                }
                return this.instance.target().asClass().name().toString();
            }

            private AccessTokenInstanceBuildItem build() {
                return new AccessTokenInstanceBuildItem(this.toClientName(), this.toExchangeToken(), this.instance.target(), this.methodInfo());
            }
        }
        List<ItemBuilder> itemBuilders = accessTokenAnnotations.stream().map(x$0 -> new ItemBuilder((AnnotationInstance)x$0)).toList();
        if (!itemBuilders.isEmpty()) {
            Map<String, List<ItemBuilder>> targetClassToBuilders = itemBuilders.stream().collect(Collectors.groupingBy(ItemBuilder::targetClassName));
            targetClassToBuilders.forEach((targetClassName, classBuilders) -> {
                if (classBuilders.size() > 1 && classBuilders.stream().map(ItemBuilder::methodInfo).anyMatch(Objects::isNull)) {
                    throw new RuntimeException(String.valueOf(ACCESS_TOKEN) + " annotation can be applied either on class " + targetClassName + " or its methods");
                }
            });
        }
        return itemBuilders.stream().map(ItemBuilder::build).toList();
    }
}

