/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.common.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.MethodInfo;

public final class AccessTokenInstanceBuildItem
extends MultiBuildItem {
    private final String clientName;
    private final boolean tokenExchange;
    private final AnnotationTarget annotationTarget;
    private final MethodInfo targetMethodInfo;

    AccessTokenInstanceBuildItem(String clientName, Boolean tokenExchange, AnnotationTarget annotationTarget, MethodInfo targetMethodInfo) {
        this.clientName = Objects.requireNonNull(clientName);
        this.tokenExchange = tokenExchange;
        this.annotationTarget = Objects.requireNonNull(annotationTarget);
        this.targetMethodInfo = targetMethodInfo;
    }

    String getClientName() {
        return this.clientName;
    }

    boolean exchangeTokenActivated() {
        return this.tokenExchange;
    }

    public AnnotationTarget getAnnotationTarget() {
        return this.annotationTarget;
    }

    public String targetClass() {
        if (this.annotationTarget.kind() == AnnotationTarget.Kind.CLASS) {
            return this.annotationTarget.asClass().name().toString();
        }
        return this.annotationTarget.asMethod().declaringClass().name().toString();
    }

    MethodInfo getTargetMethodInfo() {
        return this.targetMethodInfo;
    }
}

