/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.common.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.oidc.token.propagation.common.deployment.AccessTokenInstanceBuildItem;
import io.quarkus.security.spi.runtime.MethodDescription;
import jakarta.annotation.Priority;
import jakarta.inject.Singleton;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jandex.MethodInfo;

public final class AccessTokenRequestFilterGenerator {
    private static final int AUTHENTICATION = 1000;
    private final BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer;
    private final BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer;
    private final Class<?> requestFilterClass;
    private final Map<RequestFilterKey, String> cache = new HashMap<RequestFilterKey, String>();

    public AccessTokenRequestFilterGenerator(BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer, Class<?> requestFilterClass) {
        this.unremovableBeansProducer = unremovableBeansProducer;
        this.reflectiveClassProducer = reflectiveClassProducer;
        this.generatedBeanProducer = generatedBeanProducer;
        this.requestFilterClass = requestFilterClass;
    }

    public String generateClass(AccessTokenInstanceBuildItem instance) {
        return this.cache.computeIfAbsent(new RequestFilterKey(instance.getClientName(), instance.exchangeTokenActivated(), instance.getTargetMethodInfo()), i -> {
            String className;
            block28: {
                GeneratedBeanGizmoAdaptor adaptor = new GeneratedBeanGizmoAdaptor(this.generatedBeanProducer);
                className = this.createUniqueClassName((RequestFilterKey)i);
                try (ClassCreator classCreator = ClassCreator.builder().className(className).superClass(this.requestFilterClass).classOutput((ClassOutput)adaptor).build();){
                    MethodCreator methodCreator;
                    classCreator.addAnnotation(Priority.class).add("value", (Object)1000);
                    classCreator.addAnnotation(Singleton.class);
                    if (!i.clientName().isEmpty()) {
                        methodCreator = classCreator.getMethodCreator("getClientName", String.class, new Class[0]);
                        try {
                            methodCreator.addAnnotation(Override.class.getName(), RetentionPolicy.CLASS);
                            methodCreator.setModifiers(4);
                            methodCreator.returnValue(methodCreator.load(i.clientName()));
                        }
                        finally {
                            if (methodCreator != null) {
                                methodCreator.close();
                            }
                        }
                    }
                    if (i.exchangeTokenActivated()) {
                        methodCreator = classCreator.getMethodCreator("isExchangeToken", Boolean.TYPE, new Class[0]);
                        try {
                            methodCreator.addAnnotation(Override.class.getName(), RetentionPolicy.CLASS);
                            methodCreator.setModifiers(4);
                            methodCreator.returnBoolean(true);
                        }
                        finally {
                            if (methodCreator != null) {
                                methodCreator.close();
                            }
                        }
                    }
                    if (i.targetMethodInfo == null) break block28;
                    methodCreator = classCreator.getMethodCreator("getMethodDescription", MethodDescription.class, new Class[0]);
                    try {
                        methodCreator.addAnnotation(Override.class.getName(), RetentionPolicy.CLASS);
                        methodCreator.setModifiers(4);
                        ResultHandle methodName = methodCreator.load(i.targetMethodInfo.name());
                        ResultHandle declaringClassName = methodCreator.load(i.targetMethodInfo.declaringClass().name().toString());
                        ResultHandle paramTypes = methodCreator.marshalAsArray(String[].class, (ResultHandle[])i.targetMethodInfo.parameterTypes().stream().map(pt -> pt.name().toString()).map(arg_0 -> ((MethodCreator)methodCreator).load(arg_0)).toArray(ResultHandle[]::new));
                        MethodDescriptor methodDescriptionCtor = MethodDescriptor.ofConstructor(MethodDescription.class, (Class[])new Class[]{String.class, String.class, String[].class});
                        ResultHandle newMethodDescription = methodCreator.newInstance(methodDescriptionCtor, new ResultHandle[]{declaringClassName, methodName, paramTypes});
                        methodCreator.returnValue(newMethodDescription);
                    }
                    finally {
                        if (methodCreator != null) {
                            methodCreator.close();
                        }
                    }
                }
            }
            this.unremovableBeansProducer.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{className}));
            this.reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).reason(this.getClass().getName()).methods().fields().constructors().build());
            return className;
        });
    }

    private String createUniqueClassName(RequestFilterKey i) {
        Object uniqueClassName = "%s_%sClient_%sTokenExchange".formatted(this.requestFilterClass.getName(), AccessTokenRequestFilterGenerator.clientName(i.clientName()), AccessTokenRequestFilterGenerator.exchangeTokenName(i.exchangeTokenActivated()));
        if (i.targetMethodInfo != null) {
            uniqueClassName = (String)uniqueClassName + "_" + i.targetMethodInfo.name();
        }
        return uniqueClassName;
    }

    private static String clientName(String clientName) {
        if (clientName.isEmpty()) {
            return "Default";
        }
        return clientName;
    }

    private static String exchangeTokenName(boolean enabled) {
        if (enabled) {
            return "Enabled";
        }
        return "Default";
    }

    private record RequestFilterKey(String clientName, boolean exchangeTokenActivated, MethodInfo targetMethodInfo) {
    }
}

