/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.common.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.oidc.token.propagation.common.AccessToken;
import io.quarkus.oidc.token.propagation.common.deployment.AccessTokenInstanceBuildItem;
import java.util.Collection;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class OidcTokenPropagationCommonProcessor {
    private static final DotName ACCESS_TOKEN = DotName.createSimple((String)AccessToken.class.getName());

    @BuildStep
    public List<AccessTokenInstanceBuildItem> collectAccessTokenInstances(CombinedIndexBuildItem index) {
        Collection accessTokenAnnotations = index.getIndex().getAnnotations(ACCESS_TOKEN);
        record ItemBuilder(AnnotationInstance instance) {
            private String toClientName() {
                AnnotationValue value = this.instance.value("exchangeTokenClient");
                return value == null || value.asString().equals("Default") ? "" : value.asString();
            }

            private boolean toExchangeToken() {
                return this.instance.value("exchangeTokenClient") != null;
            }

            private AccessTokenInstanceBuildItem build() {
                return new AccessTokenInstanceBuildItem(this.toClientName(), this.toExchangeToken(), this.instance.target());
            }
        }
        return accessTokenAnnotations.stream().map(x$0 -> new ItemBuilder((AnnotationInstance)x$0)).map(ItemBuilder::build).toList();
    }
}

