/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.redis.token.state.manager.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.redis.token.state.manager.deployment.OidcRedisTokenStateManagerBuildConfig;
import io.quarkus.oidc.redis.token.state.manager.runtime.OidcRedisTokenStateManagerRecorder;
import io.quarkus.redis.client.RedisClientName;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.deployment.client.RequestedRedisClientBuildItem;
import io.quarkus.redis.runtime.client.config.RedisConfig;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcRedisTokenStateManagerProcessor {
    @BuildStep
    RequestedRedisClientBuildItem requestRedisClient(OidcRedisTokenStateManagerBuildConfig buildConfig) {
        return new RequestedRedisClientBuildItem(buildConfig.redisClientName());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    SyntheticBeanBuildItem createTokenStateManager(OidcRedisTokenStateManagerRecorder recorder, OidcRedisTokenStateManagerBuildConfig buildConfig) {
        String redisClientName = buildConfig.redisClientName();
        SyntheticBeanBuildItem.ExtendedBeanConfigurator beanConfigurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TokenStateManager.class).priority(1)).alternative(true)).unremovable()).scope(ApplicationScoped.class);
        if (RedisConfig.isDefaultClient((String)redisClientName)) {
            beanConfigurator.createWith(recorder.createTokenStateManager(null)).addInjectionPoint(Type.create(ReactiveRedisDataSource.class), new AnnotationInstance[0]);
        } else {
            beanConfigurator.createWith(recorder.createTokenStateManager(redisClientName)).addInjectionPoint(Type.create(ReactiveRedisDataSource.class), new AnnotationInstance[]{AnnotationInstance.builder(RedisClientName.class).value(redisClientName).build()});
        }
        return beanConfigurator.done();
    }

    static final class IsEnabled
    implements BooleanSupplier {
        private final boolean enabled;

        IsEnabled(OidcRedisTokenStateManagerBuildConfig buildConfig) {
            this.enabled = buildConfig.enabled();
        }

        @Override
        public boolean getAsBoolean() {
            return this.enabled;
        }
    }
}

