/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.oidc.client.runtime.AbstractTokensProducer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class OidcClientFilterDeploymentHelper<T extends AbstractTokensProducer> {
    public static final String DEFAULT_OIDC_REQUEST_FILTER_NAME = "default-oidc-request-filter";
    private final Map<String, String> clientNameToGeneratedClass = new HashMap<String, String>();
    private final Class<T> baseClass;
    private final ClassOutput classOutput;
    private final String targetPackage;
    private final boolean refreshOnUnauthorized;

    public OidcClientFilterDeploymentHelper(Class<T> baseClass, BuildProducer<GeneratedBeanBuildItem> generatedBean, boolean refreshOnUnauthorized) {
        this.baseClass = baseClass;
        this.classOutput = new GeneratedBeanGizmoAdaptor(generatedBean);
        this.targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)DotName.createSimple((String)baseClass.getName()));
        this.refreshOnUnauthorized = refreshOnUnauthorized;
    }

    public String getOrCreateNamedTokensProducerFor(final String oidcClientName) {
        Objects.requireNonNull(oidcClientName);
        return this.clientNameToGeneratedClass.computeIfAbsent(oidcClientName, new Function<String, String>(){

            @Override
            public String apply(String s) {
                String generatedName;
                block20: {
                    generatedName = OidcClientFilterDeploymentHelper.this.targetPackage + OidcClientFilterDeploymentHelper.this.baseClass.getSimpleName() + "_" + OidcClientFilterDeploymentHelper.sanitize(oidcClientName);
                    try (ClassCreator creator = ClassCreator.builder().classOutput(OidcClientFilterDeploymentHelper.this.classOutput).className(generatedName).superClass(OidcClientFilterDeploymentHelper.this.baseClass).build();){
                        creator.addAnnotation(DotNames.SINGLETON.toString());
                        creator.addAnnotation(DotNames.UNREMOVABLE.toString());
                        if (!OidcClientFilterDeploymentHelper.DEFAULT_OIDC_REQUEST_FILTER_NAME.equals(oidcClientName)) {
                            try (MethodCreator clientIdMethod = creator.getMethodCreator("clientId", Optional.class, new Class[0]);){
                                clientIdMethod.setModifiers(4);
                                clientIdMethod.returnValue(clientIdMethod.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{clientIdMethod.load(oidcClientName)}));
                            }
                        }
                        if (!OidcClientFilterDeploymentHelper.this.refreshOnUnauthorized) break block20;
                        try (MethodCreator methodCreator = creator.getMethodCreator("refreshOnUnauthorized", Boolean.TYPE, new Class[0]);){
                            methodCreator.setModifiers(4);
                            methodCreator.returnBoolean(true);
                        }
                    }
                }
                return generatedName.replace('/', '.');
            }
        });
    }

    public DotName getOrCreateFilter(String oidcClientName) {
        return DotName.createSimple((String)this.getOrCreateNamedTokensProducerFor(oidcClientName));
    }

    public static String getClientName(AnnotationInstance annotationInstance) {
        AnnotationValue annotationValue = annotationInstance.value();
        if (annotationValue != null && !annotationValue.asString().isEmpty()) {
            return annotationValue.asString();
        }
        return null;
    }

    public static String sanitize(String oidcClientName) {
        return oidcClientName.replaceAll("\\W+", "");
    }

    public static List<ClassInfo> detectCustomFiltersThatRequireResponseFilter(Class<?> abstractFilterClass, Class<?> registerProviderClass, IndexView index) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (ClassInfo subClass : index.getKnownDirectSubclasses(abstractFilterClass)) {
            DotName declaringClassName;
            boolean declaredOnThisClass;
            MethodInfo refreshOnUnauthorizedMethod;
            if (subClass.isInterface() || subClass.isAbstract() || (refreshOnUnauthorizedMethod = subClass.method("refreshOnUnauthorized", new Type[0])) == null || !(declaredOnThisClass = (declaringClassName = refreshOnUnauthorizedMethod.declaringClass().name()).equals((Object)subClass.name()))) continue;
            result.addAll(index.getAnnotations(registerProviderClass).stream().filter(ai -> ai.value() != null).filter(ai -> ai.value().asClass().name().equals((Object)declaringClassName)).filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).map(ai -> ai.target().asClass()).toList());
        }
        return result;
    }
}

