/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.observability.common.config.ContainerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public abstract class ObservabilityContainer<T extends ObservabilityContainer<T, C>, C extends ContainerConfig>
extends GenericContainer<T> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Logger dockerLog = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + ".docker"));

    public ObservabilityContainer(C config) {
        super(DockerImageName.parse((String)config.imageName()));
        this.withLogConsumer(this.frameConsumer());
        this.withLabel(config.label(), config.serviceName());
        Optional aliases = config.networkAliases();
        aliases.map(s -> s.toArray(new String[0])).ifPresent(arg_0 -> ((ObservabilityContainer)this).withNetworkAliases(arg_0));
        if (config.shared()) {
            this.withNetwork(Network.SHARED);
        }
    }

    protected Consumer<OutputFrame> frameConsumer() {
        return frame -> this.logger().debug(frame.getUtf8String().stripTrailing());
    }

    protected byte[] getResourceAsBytes(String resource) {
        byte[] byArray;
        block8: {
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
            try {
                byArray = in.readAllBytes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            in.close();
        }
        return byArray;
    }

    protected void addFileToContainer(byte[] content, String pathInContainer) {
        this.logger().info("Content [{}]: \n{}", (Object)pathInContainer, (Object)new String(content, StandardCharsets.UTF_8));
        this.copyFileToContainer(Transferable.of((byte[])content, (int)511), pathInContainer);
    }

    protected Logger logger() {
        return this.dockerLog;
    }

    public void start() {
        this.log.info("Starting {} ...", (Object)((Object)((Object)this)).getClass().getSimpleName());
        super.start();
    }

    public void stop() {
        this.log.info("Stopping {}...", (Object)((Object)((Object)this)).getClass().getSimpleName());
        super.stop();
    }
}

