/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.observability.common.config.AbstractGrafanaConfig;
import io.quarkus.observability.common.config.LgtmConfig;
import io.quarkus.observability.testcontainers.GrafanaContainer;
import java.util.Optional;
import java.util.Set;

public class LgtmContainer
extends GrafanaContainer<LgtmContainer, LgtmConfig> {
    protected static final String LGTM_NETWORK_ALIAS = "ltgm.testcontainer.docker";

    public LgtmContainer() {
        this(new LgtmConfigImpl());
    }

    public LgtmContainer(LgtmConfig config) {
        super(config);
        this.addExposedPorts(new int[]{config.otlpPort()});
    }

    public int getOtlpPort() {
        return this.getMappedPort(((LgtmConfig)this.config).otlpPort());
    }

    protected static class LgtmConfigImpl
    extends AbstractGrafanaConfig
    implements LgtmConfig {
        public LgtmConfigImpl() {
            this("docker.io/grafana/otel-lgtm:0.4.0");
        }

        public LgtmConfigImpl(String imageName) {
            super(imageName);
        }

        public Optional<Set<String>> networkAliases() {
            return Optional.of(Set.of("lgtm", LgtmContainer.LGTM_NETWORK_ALIAS));
        }

        public int otlpPort() {
            return 4318;
        }
    }
}

