/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.deployment;

import io.quarkus.deployment.IsDevResourcesSupportedByLaunchMode;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.observability.deployment.DevResourcesBuildItem;
import io.quarkus.observability.runtime.DevResourceShutdownRecorder;
import io.quarkus.observability.runtime.DevResourcesConfigBuilder;
import io.quarkus.observability.runtime.config.ObservabilityConfiguration;
import io.quarkus.runtime.ShutdownContext;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BuildSteps(onlyIf={IsDevResourcesSupportedByLaunchMode.class, IsEnabled.class})
class DevResourcesProcessor {
    private static final Logger log = LoggerFactory.getLogger(DevResourcesProcessor.class);
    private static final String FEATURE = "devresources";

    DevResourcesProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public RunTimeConfigBuilderBuildItem registerDevResourcesConfigSource() {
        log.info("Adding dev resources config builder");
        return new RunTimeConfigBuilderBuildItem(DevResourcesConfigBuilder.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public DevResourcesBuildItem shutdownDevResources(DevResourceShutdownRecorder recorder, ShutdownContextBuildItem shutdown) {
        recorder.shutdown((ShutdownContext)shutdown);
        return new DevResourcesBuildItem();
    }

    public static class IsEnabled
    implements BooleanSupplier {
        ObservabilityConfiguration config;

        @Override
        public boolean getAsBoolean() {
            return this.config.devResources() && !this.config.enabled();
        }
    }
}

