/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.devresource.lgtm;

import io.quarkus.observability.common.config.LgtmConfig;
import io.quarkus.observability.common.config.ModulesConfiguration;
import io.quarkus.observability.devresource.Container;
import io.quarkus.observability.devresource.ExtensionsCatalog;
import io.quarkus.observability.devresource.testcontainers.ContainerResource;
import io.quarkus.observability.testcontainers.LgtmContainer;
import java.util.HashMap;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;

public class LgtmResource
extends ContainerResource<LgtmContainer, LgtmConfig> {
    private ExtensionsCatalog catalog;

    public LgtmConfig config(ModulesConfiguration configuration) {
        return configuration.lgtm();
    }

    public LgtmConfig config(ModulesConfiguration configuration, ExtensionsCatalog catalog) {
        this.catalog = catalog;
        return this.config(configuration);
    }

    public Container<LgtmConfig> container(LgtmConfig config, ModulesConfiguration root) {
        return this.set((GenericContainer)new LgtmContainer(config));
    }

    public Map<String, String> config(int privatePort, String host, int publicPort) {
        switch (privatePort) {
            case 3000: {
                return Map.of("grafana.endpoint", String.format("http://%s:%s", host, publicPort));
            }
            case 4317: 
            case 4318: {
                return Map.of("otel-collector.url", String.format("%s:%s", host, publicPort));
            }
        }
        return Map.of();
    }

    protected LgtmContainer defaultContainer() {
        return new LgtmContainer();
    }

    public Map<String, String> doStart() {
        String host = ((LgtmContainer)this.container).getHost();
        HashMap<String, String> containerConfigs = new HashMap<String, String>();
        containerConfigs.put("grafana.endpoint", String.format("http://%s:%s", host, ((LgtmContainer)this.container).getGrafanaPort()));
        containerConfigs.put("otel-collector.url", String.format("%s:%s", host, ((LgtmContainer)this.container).getOtlpPort()));
        if (this.catalog != null && this.catalog.hasOpenTelemetry()) {
            containerConfigs.put("quarkus.otel.exporter.otlp.endpoint", String.format("http://%s:%s", host, ((LgtmContainer)this.container).getOtlpPort()));
            containerConfigs.put("quarkus.otel.exporter.otlp.protocol", "http/protobuf");
        }
        if (this.catalog != null && this.catalog.hasMicrometerOtlp()) {
            containerConfigs.put("quarkus.micrometer.export.otlp.url", String.format("http://%s:%s/v1/metrics", host, ((LgtmContainer)this.container).getOtlpPort()));
        }
        return containerConfigs;
    }

    public int order() {
        return 10000;
    }
}

