/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.kotlin.runtime;

import com.mongodb.ReadPreference;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Collation;
import io.quarkus.mongodb.panache.common.runtime.CommonPanacheQueryImpl;
import io.quarkus.mongodb.panache.kotlin.PanacheQuery;
import io.quarkus.panache.common.Page;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B9\b\u0010\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fB\u0017\b\u0012\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ&\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0003\"\b\b\u0001\u0010\u0011*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0017H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010+\u001a\u00020\u0017H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0016J\u000f\u00102\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00103J\u000f\u00104\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00103R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/quarkus/mongodb/panache/kotlin/runtime/PanacheQueryImpl;", "Entity", "", "Lio/quarkus/mongodb/panache/kotlin/PanacheQuery;", "collection", "Lcom/mongodb/client/MongoCollection;", "session", "Lcom/mongodb/client/ClientSession;", "mongoQuery", "Lorg/bson/conversions/Bson;", "sort", "<init>", "(Lcom/mongodb/client/MongoCollection;Lcom/mongodb/client/ClientSession;Lorg/bson/conversions/Bson;Lorg/bson/conversions/Bson;)V", "delegate", "Lio/quarkus/mongodb/panache/common/runtime/CommonPanacheQueryImpl;", "(Lio/quarkus/mongodb/panache/common/runtime/CommonPanacheQueryImpl;)V", "project", "T", "type", "Ljava/lang/Class;", "page", "Lio/quarkus/panache/common/Page;", "pageIndex", "", "pageSize", "nextPage", "previousPage", "firstPage", "lastPage", "hasNextPage", "", "hasPreviousPage", "pageCount", "range", "startIndex", "lastIndex", "withCollation", "collation", "Lcom/mongodb/client/model/Collation;", "withReadPreference", "readPreference", "Lcom/mongodb/ReadPreference;", "withBatchSize", "batchSize", "count", "", "list", "", "stream", "Ljava/util/stream/Stream;", "firstResult", "()Ljava/lang/Object;", "singleResult", "quarkus-mongodb-panache-kotlin"})
public final class PanacheQueryImpl<Entity>
implements PanacheQuery<Entity> {
    @NotNull
    private final CommonPanacheQueryImpl<Entity> delegate;

    public PanacheQueryImpl(@Nullable MongoCollection<? extends Entity> collection, @Nullable ClientSession session, @Nullable Bson mongoQuery, @Nullable Bson sort) {
        this.delegate = new CommonPanacheQueryImpl(collection, session, mongoQuery, sort);
    }

    private PanacheQueryImpl(CommonPanacheQueryImpl<Entity> delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public <T> PanacheQuery<T> project(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        CommonPanacheQueryImpl commonPanacheQueryImpl = this.delegate.project(type);
        Intrinsics.checkNotNullExpressionValue((Object)commonPanacheQueryImpl, (String)"project(...)");
        return new PanacheQueryImpl<Entity>(commonPanacheQueryImpl);
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> page(@NotNull Page page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.delegate.page(page);
        return this;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> page(int pageIndex, int pageSize) {
        Page page = Page.of((int)pageIndex, (int)pageSize);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"of(...)");
        return this.page(page);
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> nextPage() {
        this.delegate.nextPage();
        return this;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> previousPage() {
        this.delegate.previousPage();
        return this;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> firstPage() {
        this.delegate.firstPage();
        return this;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> lastPage() {
        this.delegate.lastPage();
        return this;
    }

    @Override
    public boolean hasNextPage() {
        return this.delegate.hasNextPage();
    }

    @Override
    public boolean hasPreviousPage() {
        return this.delegate.hasPreviousPage();
    }

    @Override
    public int pageCount() {
        return this.delegate.pageCount();
    }

    @Override
    @NotNull
    public Page page() {
        Page page = this.delegate.page();
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"page(...)");
        return page;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> range(int startIndex, int lastIndex) {
        this.delegate.range(startIndex, lastIndex);
        return this;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> withCollation(@NotNull Collation collation) {
        Intrinsics.checkNotNullParameter((Object)collation, (String)"collation");
        this.delegate.withCollation(collation);
        return this;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> withReadPreference(@Nullable ReadPreference readPreference) {
        this.delegate.withReadPreference(readPreference);
        return this;
    }

    @Override
    @NotNull
    public PanacheQuery<Entity> withBatchSize(int batchSize) {
        this.delegate.withBatchSize(batchSize);
        return this;
    }

    @Override
    public long count() {
        return this.delegate.count();
    }

    @Override
    @NotNull
    public List<Entity> list() {
        List list = this.delegate.list();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list(...)");
        return list;
    }

    @Override
    @NotNull
    public Stream<Entity> stream() {
        Stream stream = this.delegate.stream();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream(...)");
        return stream;
    }

    @Override
    @Nullable
    public Entity firstResult() {
        return (Entity)this.delegate.firstResult();
    }

    @Override
    @Nullable
    public Entity singleResult() {
        return (Entity)this.delegate.singleResult();
    }
}

