/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.common.reactive.runtime;

import com.mongodb.ReadPreference;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.DeleteResult;
import io.quarkus.mongodb.panache.common.MongoEntity;
import io.quarkus.mongodb.panache.common.binder.NativeQueryBinder;
import io.quarkus.mongodb.panache.common.binder.PanacheQlQueryBinder;
import io.quarkus.mongodb.panache.common.reactive.Panache;
import io.quarkus.mongodb.panache.common.runtime.BeanUtils;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.reactive.ReactiveMongoCollection;
import io.quarkus.mongodb.reactive.ReactiveMongoDatabase;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.jboss.logging.Logger;

public abstract class ReactiveMongoOperations<QueryType, UpdateType> {
    public final String ID = "_id";
    private static final Logger LOGGER = Logger.getLogger(ReactiveMongoOperations.class);
    private static final List<String> UPDATE_OPERATORS = Arrays.asList("$currentDate", "$inc", "$min", "$max", "$mul", "$rename", "$set", "$setOnInsert", "$unset", "$addToSet", "$pop", "$pull", "$push", "$pullAll", "$each", "$position", "$slice", "$sort", "$bit");
    private static final Map<String, String> defaultDatabaseName = new ConcurrentHashMap<String, String>();

    protected abstract QueryType createQuery(ReactiveMongoCollection var1, Bson var2, Bson var3);

    protected abstract UpdateType createUpdate(ReactiveMongoCollection<?> var1, Class<?> var2, Bson var3);

    protected abstract Uni<?> list(QueryType var1);

    protected abstract Multi<?> stream(QueryType var1);

    public Uni<Void> persist(Object entity) {
        ReactiveMongoCollection collection = this.mongoCollection(entity);
        return this.persist(collection, entity);
    }

    public Uni<Void> persist(Iterable<?> entities) {
        return Uni.createFrom().deferred(() -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object entity : entities) {
                objects.add(entity);
            }
            if (!objects.isEmpty()) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
                return this.persist(collection, objects);
            }
            return this.nullUni();
        });
    }

    public Uni<Void> persist(Object firstEntity, Object ... entities) {
        ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            return this.persist(collection, firstEntity);
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        entityList.add(firstEntity);
        entityList.addAll(Arrays.asList(entities));
        return this.persist(collection, entityList);
    }

    public Uni<Void> persist(Stream<?> entities) {
        return Uni.createFrom().deferred(() -> {
            List<Object> objects = entities.collect(Collectors.toList());
            if (!objects.isEmpty()) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
                return this.persist(collection, objects);
            }
            return this.nullUni();
        });
    }

    public Uni<Void> update(Object entity) {
        ReactiveMongoCollection collection = this.mongoCollection(entity);
        return this.update(collection, entity);
    }

    public Uni<Void> update(Iterable<?> entities) {
        return Uni.createFrom().deferred(() -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object entity : entities) {
                objects.add(entity);
            }
            if (!objects.isEmpty()) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
                return this.update(collection, objects);
            }
            return this.nullUni();
        });
    }

    public Uni<Void> update(Object firstEntity, Object ... entities) {
        ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            return this.update(collection, firstEntity);
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        entityList.add(firstEntity);
        entityList.addAll(Arrays.asList(entities));
        return this.update(collection, entityList);
    }

    public Uni<Void> update(Stream<?> entities) {
        return Uni.createFrom().deferred(() -> {
            List<Object> objects = entities.collect(Collectors.toList());
            if (!objects.isEmpty()) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
                return this.update(collection, objects);
            }
            return this.nullUni();
        });
    }

    public Uni<Void> persistOrUpdate(Object entity) {
        ReactiveMongoCollection collection = this.mongoCollection(entity);
        return this.persistOrUpdate(collection, entity);
    }

    public Uni<Void> persistOrUpdate(Iterable<?> entities) {
        return Uni.createFrom().deferred(() -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object entity : entities) {
                objects.add(entity);
            }
            if (!objects.isEmpty()) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
                return this.persistOrUpdate(collection, objects);
            }
            return this.nullUni();
        });
    }

    public Uni<Void> persistOrUpdate(Object firstEntity, Object ... entities) {
        ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            return this.persistOrUpdate(collection, firstEntity);
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        entityList.add(firstEntity);
        entityList.addAll(Arrays.asList(entities));
        return this.persistOrUpdate(collection, entityList);
    }

    public Uni<Void> persistOrUpdate(Stream<?> entities) {
        return Uni.createFrom().deferred(() -> {
            List<Object> objects = entities.collect(Collectors.toList());
            if (!objects.isEmpty()) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = this.mongoCollection(firstEntity);
                return this.persistOrUpdate(collection, objects);
            }
            return this.nullUni();
        });
    }

    public Uni<Void> delete(Object entity) {
        ReactiveMongoCollection collection = this.mongoCollection(entity);
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)"_id");
        BsonDocument query = new BsonDocument().append("_id", id);
        if (Panache.getCurrentSession() != null) {
            return collection.deleteOne(Panache.getCurrentSession(), (Bson)query).onItem().ignore().andContinueWithNull();
        }
        return collection.deleteOne((Bson)query).onItem().ignore().andContinueWithNull();
    }

    public ReactiveMongoCollection mongoCollection(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        ReactiveMongoDatabase database = this.mongoDatabase(mongoEntity);
        if (mongoEntity != null) {
            ReactiveMongoCollection collection;
            ReactiveMongoCollection reactiveMongoCollection = collection = mongoEntity.collection().isEmpty() ? database.getCollection(entityClass.getSimpleName(), entityClass) : database.getCollection(mongoEntity.collection(), entityClass);
            if (!mongoEntity.readPreference().isEmpty()) {
                try {
                    collection = collection.withReadPreference(ReadPreference.valueOf((String)mongoEntity.readPreference()));
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Illegal read preference " + mongoEntity.readPreference() + " configured in the @MongoEntity annotation of " + entityClass.getName() + ". Supported values are primary|primaryPreferred|secondary|secondaryPreferred|nearest");
                }
            }
            return collection;
        }
        return database.getCollection(entityClass.getSimpleName(), entityClass);
    }

    public ReactiveMongoDatabase mongoDatabase(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        return this.mongoDatabase(mongoEntity);
    }

    public Uni<Void> nullUni() {
        return Uni.createFrom().item((Object)null);
    }

    private Uni<Void> persist(ReactiveMongoCollection collection, Object entity) {
        if (Panache.getCurrentSession() != null) {
            return collection.insertOne(Panache.getCurrentSession(), entity).onItem().ignore().andContinueWithNull();
        }
        return collection.insertOne(entity).onItem().ignore().andContinueWithNull();
    }

    private Uni<Void> persist(ReactiveMongoCollection collection, List<Object> entities) {
        if (Panache.getCurrentSession() != null) {
            return collection.insertMany(Panache.getCurrentSession(), entities).onItem().ignore().andContinueWithNull();
        }
        return collection.insertMany(entities).onItem().ignore().andContinueWithNull();
    }

    private Uni<Void> update(ReactiveMongoCollection collection, Object entity) {
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)"_id");
        BsonDocument query = new BsonDocument().append("_id", id);
        if (Panache.getCurrentSession() != null) {
            return collection.replaceOne(Panache.getCurrentSession(), (Bson)query, entity).onItem().ignore().andContinueWithNull();
        }
        return collection.replaceOne((Bson)query, entity).onItem().ignore().andContinueWithNull();
    }

    private Uni<Void> update(ReactiveMongoCollection collection, List<Object> entities) {
        List unis = entities.stream().map(entity -> this.update(collection, entity)).collect(Collectors.toList());
        return Uni.combine().all().unis(unis).with(u -> null);
    }

    private Uni<Void> persistOrUpdate(ReactiveMongoCollection collection, Object entity) {
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)"_id");
        if (id == null) {
            if (Panache.getCurrentSession() != null) {
                return collection.insertOne(Panache.getCurrentSession(), entity).onItem().ignore().andContinueWithNull();
            }
            return collection.insertOne(entity).onItem().ignore().andContinueWithNull();
        }
        BsonDocument query = new BsonDocument().append("_id", id);
        if (Panache.getCurrentSession() != null) {
            return collection.replaceOne(Panache.getCurrentSession(), (Bson)query, entity, new ReplaceOptions().upsert(true)).onItem().ignore().andContinueWithNull();
        }
        return collection.replaceOne((Bson)query, entity, new ReplaceOptions().upsert(true)).onItem().ignore().andContinueWithNull();
    }

    private Uni<Void> persistOrUpdate(ReactiveMongoCollection collection, List<Object> entities) {
        ArrayList<Object> bulk = new ArrayList<Object>();
        for (Object entity : entities) {
            BsonDocument document = this.getBsonDocument(collection, entity);
            BsonValue id = document.get((Object)"_id");
            if (id == null) {
                bulk.add(new InsertOneModel(entity));
                continue;
            }
            BsonDocument query = new BsonDocument().append("_id", id);
            bulk.add(new ReplaceOneModel((Bson)query, entity, new ReplaceOptions().upsert(true)));
        }
        if (Panache.getCurrentSession() != null) {
            return collection.bulkWrite(Panache.getCurrentSession(), bulk).onItem().ignore().andContinueWithNull();
        }
        return collection.bulkWrite(bulk).onItem().ignore().andContinueWithNull();
    }

    private BsonDocument getBsonDocument(ReactiveMongoCollection collection, Object entity) {
        BsonDocument document = new BsonDocument();
        Codec codec = collection.getCodecRegistry().get(entity.getClass());
        codec.encode((BsonWriter)new BsonDocumentWriter(document), entity, EncoderContext.builder().build());
        return document;
    }

    private ReactiveMongoCollection mongoCollection(Object entity) {
        Class<?> entityClass = entity.getClass();
        return this.mongoCollection(entityClass);
    }

    private ReactiveMongoDatabase mongoDatabase(MongoEntity mongoEntity) {
        ReactiveMongoClient mongoClient = BeanUtils.clientFromArc(mongoEntity, ReactiveMongoClient.class, true);
        if (mongoEntity != null && !mongoEntity.database().isEmpty()) {
            return mongoClient.getDatabase(mongoEntity.database());
        }
        String databaseName = BeanUtils.getDatabaseNameFromResolver().orElseGet(() -> this.getDefaultDatabaseName(mongoEntity));
        return mongoClient.getDatabase(databaseName);
    }

    private String getDefaultDatabaseName(final MongoEntity mongoEntity) {
        return defaultDatabaseName.computeIfAbsent(BeanUtils.beanName(mongoEntity), new Function<String, String>(){

            @Override
            public String apply(String beanName) {
                return BeanUtils.getDatabaseName(mongoEntity, beanName);
            }
        });
    }

    public Uni<Object> findById(Class<?> entityClass, Object id) {
        Uni<Optional> optionalEntity = this.findByIdOptional(entityClass, id);
        return optionalEntity.onItem().transform(optional -> optional.orElse(null));
    }

    public Uni<Optional> findByIdOptional(Class<?> entityClass, Object id) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.find(Panache.getCurrentSession(), (Bson)new Document("_id", id)).collect().first().onItem().transform(Optional::ofNullable);
        }
        return collection.find((Bson)new Document("_id", id)).collect().first().onItem().transform(Optional::ofNullable);
    }

    public <Entity, ID> Uni<List<Entity>> findByIds(Class<?> entityClass, List<ID> ids) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        List<Object> nonNullIds = ids.stream().filter(Objects::nonNull).toList();
        if (Panache.getCurrentSession() != null) {
            return collection.find(Panache.getCurrentSession(), Filters.in((String)"_id", nonNullIds)).collect().asList();
        }
        return collection.find(Filters.in((String)"_id", nonNullIds)).collect().asList();
    }

    public QueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Bson docSort = this.sortToDocument(sort);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, (Bson)docQuery, docSort);
    }

    public String bindFilter(Class<?> clazz, String query, Object[] params) {
        String bindQuery = this.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    public String bindFilter(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = this.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    String bindUpdate(Class<?> clazz, String query, Object[] params) {
        Object bindUpdate = this.bindQuery(clazz, query, params);
        if (!this.containsUpdateOperator(query)) {
            bindUpdate = "{'$set':" + (String)bindUpdate + "}";
        }
        LOGGER.debug(bindUpdate);
        return bindUpdate;
    }

    String bindUpdate(Class<?> clazz, String query, Map<String, Object> params) {
        Object bindUpdate = this.bindQuery(clazz, query, params);
        if (!this.containsUpdateOperator(query)) {
            bindUpdate = "{'$set':" + (String)bindUpdate + "}";
        }
        LOGGER.debug(bindUpdate);
        return bindUpdate;
    }

    private boolean containsUpdateOperator(String update) {
        for (String operator : UPDATE_OPERATORS) {
            if (!update.contains(operator)) continue;
            return true;
        }
        return false;
    }

    String bindQuery(Class<?> clazz, String query, Object[] params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    String bindQuery(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    public QueryType find(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.find(entityClass, query, null, params);
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Bson docSort = this.sortToDocument(sort);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, (Bson)docQuery, docSort);
    }

    public QueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, null, params.map());
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public QueryType find(Class<?> entityClass, Bson query, Sort sort) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        Bson sortDoc = this.sortToDocument(sort);
        return this.createQuery(collection, query, sortDoc);
    }

    public QueryType find(Class<?> entityClass, Bson query, Bson sort) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, query, sort);
    }

    public QueryType find(Class<?> entityClass, Bson query) {
        return this.find(entityClass, query, (Bson)null);
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Uni<List<?>> list(Class<?> entityClass, Bson query) {
        return this.list(this.find(entityClass, query));
    }

    public Uni<List<?>> list(Class<?> entityClass, Bson query, Bson sort) {
        return this.list(this.find(entityClass, query, sort));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Object ... params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Parameters params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Multi<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Multi<?> stream(Class<?> entityClass, Bson query) {
        return this.stream(this.find(entityClass, query));
    }

    public Multi<?> stream(Class<?> entityClass, Bson query, Bson sort) {
        return this.stream(this.find(entityClass, query, sort));
    }

    public QueryType findAll(Class<?> entityClass) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, null, null);
    }

    public QueryType findAll(Class<?> entityClass, Sort sort) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        Bson sortDoc = this.sortToDocument(sort);
        return this.createQuery(collection, null, sortDoc);
    }

    private Bson sortToDocument(Sort sort) {
        if (sort == null) {
            return null;
        }
        Document sortDoc = new Document();
        for (Sort.Column col : sort.getColumns()) {
            sortDoc.append(col.getName(), (Object)(col.getDirection() == Sort.Direction.Ascending ? 1 : -1));
            if (col.getNullPrecedence() == null) continue;
            throw new UnsupportedOperationException("Cannot sort by nulls first or nulls last");
        }
        return sortDoc;
    }

    public Uni<List<?>> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public Uni<List<?>> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Multi<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Multi<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public Uni<Long> count(Class<?> entityClass) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.countDocuments(Panache.getCurrentSession());
        }
        return collection.countDocuments();
    }

    public Uni<Long> count(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.countDocuments(Panache.getCurrentSession(), (Bson)docQuery);
        }
        return collection.countDocuments((Bson)docQuery);
    }

    public Uni<Long> count(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.countDocuments(Panache.getCurrentSession(), (Bson)docQuery);
        }
        return collection.countDocuments((Bson)docQuery);
    }

    public Uni<Long> count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public Uni<Long> count(Class<?> entityClass, Bson query) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.countDocuments(Panache.getCurrentSession(), query);
        }
        return collection.countDocuments(query);
    }

    public Uni<Long> deleteAll(Class<?> entityClass) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.deleteMany(Panache.getCurrentSession(), (Bson)new Document()).map(DeleteResult::getDeletedCount);
        }
        return collection.deleteMany((Bson)new Document()).map(DeleteResult::getDeletedCount);
    }

    public Uni<Boolean> deleteById(Class<?> entityClass, Object id) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        Document query = new Document().append("_id", id);
        if (Panache.getCurrentSession() != null) {
            return collection.deleteOne(Panache.getCurrentSession(), (Bson)query).map(results -> results.getDeletedCount() == 1L);
        }
        return collection.deleteOne((Bson)query).map(results -> results.getDeletedCount() == 1L);
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.deleteMany(Panache.getCurrentSession(), (Bson)docQuery).map(DeleteResult::getDeletedCount);
        }
        return collection.deleteMany((Bson)docQuery).map(DeleteResult::getDeletedCount);
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.deleteMany(Panache.getCurrentSession(), (Bson)docQuery).map(DeleteResult::getDeletedCount);
        }
        return collection.deleteMany((Bson)docQuery).map(DeleteResult::getDeletedCount);
    }

    public Uni<Long> delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public Uni<Long> delete(Class<?> entityClass, Bson query) {
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        if (Panache.getCurrentSession() != null) {
            return collection.deleteMany(Panache.getCurrentSession(), query).map(DeleteResult::getDeletedCount);
        }
        return collection.deleteMany(query).map(DeleteResult::getDeletedCount);
    }

    public UpdateType update(Class<?> entityClass, String update, Map<String, Object> params) {
        return this.executeUpdate(entityClass, update, params);
    }

    public UpdateType update(Class<?> entityClass, String update, Parameters params) {
        return this.update(entityClass, update, params.map());
    }

    public UpdateType update(Class<?> entityClass, String update, Object ... params) {
        return this.executeUpdate(entityClass, update, params);
    }

    public UpdateType update(Class<?> entityClass, Bson update) {
        return this.createUpdate(this.mongoCollection(entityClass), entityClass, update);
    }

    private UpdateType executeUpdate(Class<?> entityClass, String update, Object ... params) {
        String bindUpdate = this.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        return this.createUpdate(collection, entityClass, (Bson)docUpdate);
    }

    private UpdateType executeUpdate(Class<?> entityClass, String update, Map<String, Object> params) {
        String bindUpdate = this.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        ReactiveMongoCollection collection = this.mongoCollection(entityClass);
        return this.createUpdate(collection, entityClass, (Bson)docUpdate);
    }

    public IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses");
    }
}

