/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.common.reactive;

import com.mongodb.reactivestreams.client.ClientSession;
import io.quarkus.mongodb.panache.common.runtime.BeanUtils;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.UUID;
import java.util.function.Supplier;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import org.reactivestreams.Publisher;

public class Panache {
    private static final String ERROR_MSG = "MongoDB reactive with Panache requires a safe (isolated) Vert.x sub-context, but the current context hasn't been flagged as such.";
    private static final UUID SESSION_KEY = UUID.randomUUID();

    public static <T> Uni<T> withTransaction(Supplier<Uni<T>> work) {
        Context context = Panache.vertxContext();
        ClientSession current = (ClientSession)context.getLocal((Object)SESSION_KEY);
        if (current != null && current.hasActiveTransaction()) {
            return work.get();
        }
        return Panache.startSession().invoke(s -> s.startTransaction()).invoke(s -> context.putLocal((Object)SESSION_KEY, s)).chain(s -> (Uni)work.get()).call(() -> Panache.commitTransaction()).onFailure().call(() -> Panache.abortTransaction()).eventually(() -> Panache.closeSession());
    }

    public static ClientSession getCurrentSession() {
        Context context = Vertx.currentContext();
        return context != null ? (ClientSession)context.getLocal((Object)SESSION_KEY) : null;
    }

    private static Uni<?> abortTransaction() {
        Context context = Panache.vertxContext();
        ClientSession current = (ClientSession)context.getLocal((Object)SESSION_KEY);
        return Panache.toUni(current.abortTransaction());
    }

    private static Uni<?> commitTransaction() {
        Context context = Panache.vertxContext();
        ClientSession current = (ClientSession)context.getLocal((Object)SESSION_KEY);
        return Panache.toUni(current.commitTransaction());
    }

    private static <T> Uni<T> toUni(Publisher<T> publisher) {
        Context context = Vertx.currentContext();
        Uni uni = Uni.createFrom().publisher(AdaptersToFlow.publisher(publisher));
        if (context != null) {
            return uni.emitOn(command -> context.runOnContext(x -> command.run()));
        }
        return uni;
    }

    private static Uni<ClientSession> startSession() {
        ReactiveMongoClient client = BeanUtils.clientFromArc(null, ReactiveMongoClient.class, true);
        return client.startSession();
    }

    private static void closeSession() {
        Context context = Panache.vertxContext();
        ClientSession current = (ClientSession)context.getLocal((Object)SESSION_KEY);
        try {
            current.close();
        }
        finally {
            context.removeLocal((Object)SESSION_KEY);
        }
    }

    private static Context vertxContext() {
        Context context = Vertx.currentContext();
        if (context != null) {
            VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
            return context;
        }
        throw new IllegalStateException("No current Vertx context found");
    }
}

