/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.common.binder;

import io.quarkus.mongodb.panache.common.binder.CommonQueryBinder;
import io.quarkus.panacheql.internal.HqlParser;
import io.quarkus.panacheql.internal.HqlParserBaseVisitor;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

class MongoParserVisitor
extends HqlParserBaseVisitor<String> {
    private Map<String, String> replacementMap;
    private Map<String, Object> parameterMaps;

    public MongoParserVisitor(Map<String, String> replacementMap, Map<String, Object> parameterMaps) {
        this.replacementMap = replacementMap;
        this.parameterMaps = parameterMaps;
    }

    public String visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (HqlParser.PredicateContext predicate : ctx.predicate()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)predicate.accept((ParseTreeVisitor)this));
        }
        return sb.toString();
    }

    public String visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        StringBuilder sb = new StringBuilder("'$or':[");
        for (HqlParser.PredicateContext predicate : ctx.predicate()) {
            if (sb.length() > 7) {
                sb.append(",");
            }
            sb.append('{').append((String)predicate.accept((ParseTreeVisitor)this)).append('}');
        }
        sb.append("]");
        return sb.toString();
    }

    public String visitComparisonPredicate(HqlParser.ComparisonPredicateContext ctx) {
        String lhs = (String)ctx.expression(0).accept((ParseTreeVisitor)this);
        String rhs = (String)ctx.expression(1).accept((ParseTreeVisitor)this);
        if (ctx.comparisonOperator().EQUAL() != null) {
            return lhs + ":" + rhs;
        }
        if (ctx.comparisonOperator().NOT_EQUAL() != null) {
            return lhs + ":{'$ne':" + rhs + "}";
        }
        if (ctx.comparisonOperator().GREATER() != null) {
            return lhs + ":{'$gt':" + rhs + "}";
        }
        if (ctx.comparisonOperator().GREATER_EQUAL() != null) {
            return lhs + ":{'$gte':" + rhs + "}";
        }
        if (ctx.comparisonOperator().LESS() != null) {
            return lhs + ":{'$lt':" + rhs + "}";
        }
        if (ctx.comparisonOperator().LESS_EQUAL() != null) {
            return lhs + ":{'$lte':" + rhs + "}";
        }
        return (String)super.visitComparisonPredicate(ctx);
    }

    public String visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        String parameter = (String)ctx.expression(1).accept((ParseTreeVisitor)this);
        if (parameter.indexOf(47) == 1 && parameter.lastIndexOf(47) > 1) {
            parameter = parameter.substring(1, parameter.length() - 1);
        }
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":{'$regex':" + parameter + "}";
    }

    public String visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        boolean exists = ctx.NOT() != null;
        return (String)ctx.expression().accept((ParseTreeVisitor)this) + ":{'$exists':" + exists + "}";
    }

    public String visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        String text = ctx.getText();
        if (ctx.literal().STRING_LITERAL() != null) {
            text = text.substring(1, text.length() - 1);
        }
        return CommonQueryBinder.escape(text);
    }

    public String visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        return this.visitParameter((HqlParser.ParameterContext)ctx);
    }

    public String visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        return this.visitParameter((HqlParser.ParameterContext)ctx);
    }

    public String visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return this.visitParameter(ctx.parameter());
    }

    public String visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return (String)ctx.expression().accept((ParseTreeVisitor)this);
    }

    public String visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return (String)ctx.predicate().accept((ParseTreeVisitor)this);
    }

    private String visitParameter(HqlParser.ParameterContext ctx) {
        if (this.parameterMaps.containsKey(ctx.getText())) {
            Object value = this.parameterMaps.get(ctx.getText());
            return CommonQueryBinder.escape(value);
        }
        return ctx.getText();
    }

    public String visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        String identifier = this.unquote(ctx.getText());
        return "'" + this.replacementMap.getOrDefault(identifier, identifier) + "'";
    }

    private String unquote(String text) {
        if (text.startsWith("`") && text.endsWith("`") && text.length() >= 2) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public String visitInPredicate(HqlParser.InPredicateContext ctx) {
        StringBuilder sb = new StringBuilder((String)ctx.expression().accept((ParseTreeVisitor)this)).append(":{'$in':").append((String)ctx.inList().accept((ParseTreeVisitor)this)).append("}");
        return sb.toString();
    }

    public String visitStandardFunction(HqlParser.StandardFunctionContext ctx) {
        return "'" + ctx.getText() + "'";
    }
}

