/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.opentelemetry.deployment;

import io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.api.OpenTelemetry;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.micrometer.deployment.MicrometerProcessor;
import io.quarkus.micrometer.opentelemetry.runtime.MicrometerOtelBridgeRecorder;
import io.quarkus.opentelemetry.deployment.OpenTelemetryEnabled;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logmanager.Level;
import org.objectweb.asm.ClassVisitor;

@BuildSteps(onlyIf={MicrometerProcessor.MicrometerEnabled.class, OpenTelemetryEnabled.class, OtlpMetricsExporterEnabled.class})
public class MicrometerOtelBridgeProcessor {
    private static final String UNSUPPORTED_READ_LOGGER_CLASS_NAME = "io.opentelemetry.instrumentation.micrometer.v1_5.UnsupportedReadLogger";

    @BuildStep
    public void disableOTelAutoInstrumentedMetrics(BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigProducer) {
        runtimeConfigProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.otel.instrument.http-server-metrics", "false"));
        runtimeConfigProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.otel.instrument.jvm-metrics", "false"));
    }

    @BuildStep
    public void tuneDefaultConfigs(BuildProducer<LogCategoryBuildItem> logCategoryProducer) {
        logCategoryProducer.produce((BuildItem)new LogCategoryBuildItem("io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryMeterRegistry", (java.util.logging.Level)Level.ERROR));
        logCategoryProducer.produce((BuildItem)new LogCategoryBuildItem("io.micrometer.core.instrument.composite.CompositeMeterRegistry", (java.util.logging.Level)Level.ERROR));
    }

    @BuildStep
    BytecodeTransformerBuildItem silenceWarning() {
        return new BytecodeTransformerBuildItem.Builder().setClassToTransform(UNSUPPORTED_READ_LOGGER_CLASS_NAME).setCacheable(true).setVisitorFunction((BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

            @Override
            public ClassVisitor apply(String s, ClassVisitor classVisitor) {
                ClassTransformer transformer = new ClassTransformer(MicrometerOtelBridgeProcessor.UNSUPPORTED_READ_LOGGER_CLASS_NAME);
                transformer.removeMethod(MethodDescriptor.ofMethod((Object)MicrometerOtelBridgeProcessor.UNSUPPORTED_READ_LOGGER_CLASS_NAME, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
                return transformer.applyTo(classVisitor);
            }
        }).build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBridgeBean(OTelBuildConfig oTelBuildConfig, MicrometerOtelBridgeRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer) {
        if (!oTelBuildConfig.enabled()) {
            return;
        }
        syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MeterRegistry.class).defaultBean()).setRuntimeInit().unremovable()).scope(Singleton.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)OpenTelemetry.class.getName()))}, null), new AnnotationInstance[0])).createWith(recorder.createBridge()).done());
    }

    static class OtlpMetricsExporterEnabled
    implements BooleanSupplier {
        OTelBuildConfig otelBuildConfig;

        OtlpMetricsExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.metrics().enabled().orElse(Boolean.TRUE) != false && !this.otelBuildConfig.metrics().exporter().stream().map(exporter -> exporter.toLowerCase(Locale.ROOT)).anyMatch(exporter -> exporter.contains("none"));
        }
    }
}

