/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.rabbitmq.runtime;

import com.rabbitmq.client.impl.CredentialsProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;

public class CredentialsProviderLink
implements CredentialsProvider {
    private final io.quarkus.credentials.CredentialsProvider credentialsProvider;
    private final String credentialsProviderName;
    private String username;
    private String password;
    private Instant expiresAt;

    public CredentialsProviderLink(io.quarkus.credentials.CredentialsProvider credentialsProvider, String credentialsProviderName) {
        this.credentialsProvider = credentialsProvider;
        this.credentialsProviderName = credentialsProviderName;
        this.expiresAt = Instant.MIN;
    }

    private void refreshIfExpired() {
        if (this.expiresAt.isAfter(Instant.now())) {
            return;
        }
        this.refresh();
    }

    public String getUsername() {
        this.refreshIfExpired();
        return this.username;
    }

    public String getPassword() {
        this.refreshIfExpired();
        return this.password;
    }

    public Duration getTimeBeforeExpiration() {
        return Duration.between(Instant.now(), this.expiresAt);
    }

    public void refresh() {
        Map credentials = (Map)this.credentialsProvider.getCredentialsAsync(this.credentialsProviderName).await().indefinitely();
        this.username = (String)credentials.get("user");
        this.password = (String)credentials.get("password");
        this.expiresAt = Instant.parse(credentials.getOrDefault("expires-at", this.getDefaultExpiresAt()));
    }

    private String getDefaultExpiresAt() {
        return Instant.now().plusSeconds(10L).toString();
    }
}

