/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.rabbitmq.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevServicesSupportedByLaunchMode;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.smallrye.reactivemessaging.rabbitmq.deployment.RabbitMQBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.rabbitmq.deployment.RabbitMQDevServicesBuildTimeConfig;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.RabbitMQContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIf={IsDevServicesSupportedByLaunchMode.class, DevServicesConfig.Enabled.class})
public class RabbitMQDevServicesProcessor {
    private static final Logger log = Logger.getLogger(RabbitMQDevServicesProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-rabbitmq";
    private static final int RABBITMQ_PORT = 5672;
    private static final int RABBITMQ_HTTP_PORT = 15672;
    private static final ContainerLocator rabbitmqContainerLocator = ContainerLocator.locateContainerWithLabels((int)5672, (String[])new String[]{"quarkus-dev-service-rabbitmq"});
    private static final String RABBITMQ_HOST_PROP = "rabbitmq-host";
    private static final String RABBITMQ_PORT_PROP = "rabbitmq-port";
    private static final String RABBITMQ_HTTP_PORT_PROP = "rabbitmq-http-port";
    private static final String RABBITMQ_USERNAME_PROP = "rabbitmq-username";
    private static final String RABBITMQ_PASSWORD_PROP = "rabbitmq-password";
    public static final String RABBITMQ_DEFAULT_USER_PASS = "guest";
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile RabbitMQDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startRabbitMQDevService(DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, LaunchModeBuildItem launchMode, RabbitMQBuildTimeConfig rabbitmqClientBuildTimeConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig) {
        RabbitMQDevServiceCfg configuration = this.getConfiguration(rabbitmqClientBuildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.shutdownBroker();
            cfg = null;
        }
        boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "RabbitMQ Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService newDevService = this.startRabbitMQBroker(dockerStatusBuildItem, composeProjectBuildItem, configuration, launchMode, devServicesConfig.timeout(), useSharedNetwork);
            if (newDevService != null) {
                devService = newDevService;
                Map config = devService.getConfig();
                if (devService.isOwner()) {
                    log.info((Object)"Dev Services for RabbitMQ started.");
                    log.infof("Other Quarkus applications in dev mode will find the broker automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -Drabbitmq-host=%s -Drabbitmq-port=%s -Drabbitmq-username=%s -Drabbitmq-password=%s", new Object[]{config.get(RABBITMQ_HOST_PROP), config.get(RABBITMQ_PORT_PROP), config.get(RABBITMQ_USERNAME_PROP), config.get(RABBITMQ_PASSWORD_PROP)});
                }
            }
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownBroker();
                    log.info((Object)"Dev Services for RabbitMQ shut down.");
                }
                first = true;
                devService = null;
                cfg = null;
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        cfg = configuration;
        return devService.toBuildItem();
    }

    private void shutdownBroker() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the RabbitMQ broker", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startRabbitMQBroker(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, RabbitMQDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout, boolean useSharedNetwork) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting Dev Services for RabbitMQ, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyNonEmpty((String)RABBITMQ_HOST_PROP) || ConfigUtils.isPropertyNonEmpty((String)RABBITMQ_PORT_PROP)) {
            log.debug((Object)"Not starting Dev Services for RabbitMQ, the rabbitmq-host and/or rabbitmq-port are configured.");
            return null;
        }
        if (!this.hasRabbitMQChannelWithoutHostAndPort()) {
            log.debug((Object)"Not starting Dev Services for RabbitMQ, all the channels are configured.");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the RabbitMQ broker location.");
            return null;
        }
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultRabbitMQBrokerSupplier = () -> {
            ConfiguredRabbitMQContainer container = new ConfiguredRabbitMQContainer(DockerImageName.parse((String)config.imageName).asCompatibleSubstituteFor("rabbitmq"), config.fixedExposedPort, config.fixedExposedHttpPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, composeProjectBuildItem.getDefaultNetworkId(), useSharedNetwork);
            config.vhosts.forEach(arg_0 -> ((ConfiguredRabbitMQContainer)container).withVhost(arg_0));
            config.exchanges.forEach(x -> container.withExchange(x.vhost, x.name, x.type, x.autoDelete, false, x.durable, x.arguments));
            config.queues.forEach(x -> container.withQueue(x.vhost, x.name, x.autoDelete, x.durable, x.arguments));
            config.bindings.forEach(b -> container.withBinding(b.vhost, b.source, b.destination, b.arguments, b.routingKey, b.destinationType));
            timeout.ifPresent(arg_0 -> ((ConfiguredRabbitMQContainer)container).withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv);
            container.start();
            return this.getRunningDevService(container.getContainerId(), () -> ((ConfiguredRabbitMQContainer)container).close(), container.getEffectiveHost(), container.getPort(), container.getHttpPort(), container.getAdminUsername(), container.getAdminPassword());
        };
        return rabbitmqContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningDevService(config, launchMode, (ContainerAddress)containerAddress)).or(() -> ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, List.of(config.imageName, "rabbitmq"), (int)5672, (LaunchMode)launchMode.getLaunchMode(), (boolean)useSharedNetwork).map(this::getRunningDevService)).orElseGet(defaultRabbitMQBrokerSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningDevService(RabbitMQDevServiceCfg config, LaunchModeBuildItem launchMode, ContainerAddress containerAddress) {
        Integer httpPort = rabbitmqContainerLocator.locatePublicPort(config.serviceName, config.shared, launchMode.getLaunchMode(), 15672).orElse(0);
        return this.getRunningDevService(containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort(), httpPort, RABBITMQ_DEFAULT_USER_PASS, RABBITMQ_DEFAULT_USER_PASS);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningDevService(ContainerAddress address) {
        RunningContainer container = address.getRunningContainer();
        if (container == null) {
            return null;
        }
        return this.getRunningDevService(address.getId(), null, address.getHost(), address.getPort(), container.getPortMapping(15672).orElse(0), container.tryGetEnv(new String[]{"RABBITMQ_DEFAULT_USER"}).orElse(RABBITMQ_DEFAULT_USER_PASS), container.tryGetEnv(new String[]{"RABBITMQ_DEFAULT_PASS"}).orElse(RABBITMQ_DEFAULT_USER_PASS));
    }

    private DevServicesResultBuildItem.RunningDevService getRunningDevService(String containerId, Closeable closeable, String host, int port, int httpPort, String username, String password) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(RABBITMQ_HOST_PROP, host);
        configMap.put(RABBITMQ_PORT_PROP, String.valueOf(port));
        configMap.put(RABBITMQ_HTTP_PORT_PROP, String.valueOf(httpPort));
        configMap.put(RABBITMQ_USERNAME_PROP, username);
        configMap.put(RABBITMQ_PASSWORD_PROP, password);
        return new DevServicesResultBuildItem.RunningDevService(Feature.MESSAGING_RABBITMQ.getName(), containerId, closeable, configMap);
    }

    private boolean hasRabbitMQChannelWithoutHostAndPort() {
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            boolean isIncoming = name.startsWith("mp.messaging.incoming.");
            boolean isOutgoing = name.startsWith("mp.messaging.outgoing.");
            boolean isConnector = name.endsWith(".connector");
            boolean isConfigured = false;
            if ((isIncoming || isOutgoing) && isConnector) {
                String connectorValue = (String)config.getValue(name, String.class);
                boolean isRabbitMQ = connectorValue.equalsIgnoreCase("smallrye-rabbitmq");
                boolean hasHost = ConfigUtils.isPropertyNonEmpty((String)name.replace(".connector", ".host"));
                boolean hasPort = ConfigUtils.isPropertyNonEmpty((String)name.replace(".connector", ".port"));
                boolean bl = isConfigured = isRabbitMQ && (hasHost || hasPort);
            }
            if (isConfigured) continue;
            return true;
        }
        return false;
    }

    private RabbitMQDevServiceCfg getConfiguration(RabbitMQBuildTimeConfig cfg) {
        RabbitMQDevServicesBuildTimeConfig devServicesConfig = cfg.devservices();
        return new RabbitMQDevServiceCfg(devServicesConfig);
    }

    static {
        first = true;
    }

    private static final class RabbitMQDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final Integer fixedExposedHttpPort;
        private final boolean shared;
        private final String serviceName;
        private final List<Exchange> exchanges;
        private final List<Queue> queues;
        private final List<Binding> bindings;
        private final List<String> vhosts;
        private final Map<String, String> containerEnv;

        public RabbitMQDevServiceCfg(RabbitMQDevServicesBuildTimeConfig devServicesConfig) {
            this.devServicesEnabled = devServicesConfig.enabled().orElse(true);
            this.imageName = devServicesConfig.imageName();
            this.fixedExposedPort = devServicesConfig.port().orElse(0);
            this.fixedExposedHttpPort = devServicesConfig.httpPort().orElse(0);
            this.shared = devServicesConfig.shared();
            this.serviceName = devServicesConfig.serviceName();
            this.exchanges = devServicesConfig.exchanges() != null ? devServicesConfig.exchanges().entrySet().stream().map(Exchange::new).collect(Collectors.toList()) : Collections.emptyList();
            this.queues = devServicesConfig.queues() != null ? devServicesConfig.queues().entrySet().stream().map(Queue::new).collect(Collectors.toList()) : Collections.emptyList();
            this.bindings = devServicesConfig.bindings() != null ? devServicesConfig.bindings().entrySet().stream().map(Binding::new).collect(Collectors.toList()) : Collections.emptyList();
            this.vhosts = devServicesConfig.vhosts().orElse(Collections.emptyList());
            this.containerEnv = devServicesConfig.containerEnv();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RabbitMQDevServiceCfg that = (RabbitMQDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort) && Objects.equals(this.containerEnv, that.containerEnv);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort, this.containerEnv);
        }

        static class Binding {
            String source;
            String destination;
            String routingKey;
            String destinationType;
            String vhost;
            Map<String, Object> arguments;

            Binding(Map.Entry<String, RabbitMQDevServicesBuildTimeConfig.Binding> entry) {
                this(entry.getKey(), entry.getValue());
            }

            Binding(String name, RabbitMQDevServicesBuildTimeConfig.Binding source) {
                this.source = source.source().orElse(name);
                this.routingKey = source.routingKey();
                this.destination = source.destination().orElse(name);
                this.destinationType = source.destinationType();
                this.vhost = source.vhost();
                this.arguments = source.arguments() != null ? source.arguments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Map.of();
            }
        }

        static class Queue {
            String name;
            Boolean autoDelete;
            Boolean durable;
            String vhost;
            Map<String, Object> arguments;

            Queue(Map.Entry<String, RabbitMQDevServicesBuildTimeConfig.Queue> entry) {
                this(entry.getKey(), entry.getValue());
            }

            Queue(String name, RabbitMQDevServicesBuildTimeConfig.Queue source) {
                this.name = name;
                this.autoDelete = source.autoDelete();
                this.durable = source.durable();
                this.vhost = source.vhost();
                this.arguments = source.arguments() != null ? source.arguments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Map.of();
            }
        }

        static class Exchange {
            String name;
            String type;
            Boolean autoDelete;
            Boolean durable;
            String vhost;
            Map<String, Object> arguments;

            Exchange(Map.Entry<String, RabbitMQDevServicesBuildTimeConfig.Exchange> entry) {
                this(entry.getKey(), entry.getValue());
            }

            Exchange(String name, RabbitMQDevServicesBuildTimeConfig.Exchange source) {
                this.name = name;
                this.type = source.type();
                this.autoDelete = source.autoDelete();
                this.durable = source.durable();
                this.vhost = source.vhost();
                this.arguments = source.arguments() != null ? source.arguments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Map.of();
            }
        }
    }

    private static final class ConfiguredRabbitMQContainer
    extends RabbitMQContainer {
        private final int port;
        private final int httpPort;
        private final boolean useSharedNetwork;
        private final String hostName;

        private ConfiguredRabbitMQContainer(DockerImageName dockerImageName, int fixedExposedPort, int fixedExposedHttpPort, String serviceName, String defaultNetworkId, boolean useSharedNetwork) {
            super(dockerImageName);
            this.port = fixedExposedPort;
            this.httpPort = fixedExposedHttpPort;
            this.useSharedNetwork = useSharedNetwork;
            this.withExposedPorts(new Integer[]{5672, 15672});
            if (serviceName != null) {
                this.withLabel(RabbitMQDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
                this.withLabel("io.quarkus.devservice", serviceName);
            }
            if (!dockerImageName.getRepository().endsWith("rabbitmq")) {
                throw new IllegalArgumentException("Only official rabbitmq images are supported");
            }
            this.hostName = ConfigureUtil.configureNetwork((GenericContainer)this, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)"rabbitmq");
        }

        protected void configure() {
            super.configure();
            if (this.port > 0) {
                this.addFixedExposedPort(this.port, 5672);
            }
            if (this.httpPort > 0) {
                this.addFixedExposedPort(this.httpPort, 15672);
            }
        }

        public String getEffectiveHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }

        public int getPort() {
            return this.useSharedNetwork ? 5672 : this.getMappedPort(5672);
        }
    }
}

