/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.pulsar.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.pulsar.SchemaProviderRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.DefaultSchemaDiscoveryState;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.DotNames;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.Dependent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class SyntheticBeanBuilder {
    final BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItem;
    final SchemaProviderRecorder recorder;
    final RecorderContext recorderContext;
    final Map<String, String> alreadyGeneratedSchema;

    public SyntheticBeanBuilder(BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItem, SchemaProviderRecorder recorder, RecorderContext recorderContext) {
        this.syntheticBeanBuildItem = syntheticBeanBuildItem;
        this.recorder = recorder;
        this.recorderContext = recorderContext;
        this.alreadyGeneratedSchema = new HashMap<String, String>();
    }

    static String objectMapperSchemaId(Type type) {
        return "ObjectMapper<" + String.valueOf(type.name()) + ">";
    }

    String schemaIdFor(Type type) {
        return this.alreadyGeneratedSchema.get(type.name().toString());
    }

    void produceObjectMapperSchemaBean(String schemaId, Type type) {
        String typeName = type.name().toString();
        if (!this.alreadyGeneratedSchema.containsKey(typeName) || this.alreadyGeneratedSchema.get(typeName).equals(schemaId)) {
            RuntimeValue runtimeValue = this.recorder.createObjectMapperSchema(this.recorderContext.classProxy(typeName));
            this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, runtimeValue, schemaId, type);
            this.alreadyGeneratedSchema.put(typeName, schemaId);
        }
    }

    public String produceSchemaBean(DefaultSchemaDiscoveryState discovery, Type type) {
        if (this.syntheticBeanBuildItem != null && type.kind() == Type.Kind.CLASS) {
            String schemaId = this.schemaIdFor(type);
            if (schemaId == null) {
                String typeName = type.name().toString();
                if (discovery.isAvroGenerated(type.name()) || DotNames.AVRO_GENERIC_RECORD.equals((Object)type.name())) {
                    schemaId = this.generateId(type, "AVRO");
                    this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, this.recorder.createAvroSchema(this.recorderContext.classProxy(typeName)), schemaId, type);
                } else if (discovery.isProtobufGenerated(type.name())) {
                    schemaId = this.generateId(type, "PROTOBUF");
                    this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, this.recorder.createProtoBufSchema(this.recorderContext.classProxy(typeName)), schemaId, type);
                } else if (type.name().equals((Object)DotNames.VERTX_JSON_OBJECT)) {
                    schemaId = this.generateId(type, "JSON_OBJECT");
                    this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, this.recorder.createJsonObjectSchema(), schemaId, type);
                } else if (type.name().equals((Object)DotNames.VERTX_JSON_ARRAY)) {
                    schemaId = this.generateId(type, "JSON_ARRAY");
                    this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, this.recorder.createJsonArraySchema(), schemaId, type);
                } else if (type.name().equals((Object)DotNames.VERTX_BUFFER)) {
                    schemaId = this.generateId(type, "BUFFER");
                    this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, this.recorder.createBufferSchema(), schemaId, type);
                } else if (type.name().equals((Object)DotNames.BYTE_BUFFER)) {
                    schemaId = this.generateId(type, "BYTE_BUFFER");
                    this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, this.recorder.createByteBufferSchema(), schemaId, type);
                } else {
                    schemaId = this.generateId(type, "JSON");
                    this.produceSyntheticBeanSchema(this.syntheticBeanBuildItem, this.recorder.createJsonSchema(this.recorderContext.classProxy(typeName)), schemaId, type);
                }
                this.alreadyGeneratedSchema.put(typeName, schemaId);
            }
            return schemaId;
        }
        return null;
    }

    void produceSyntheticBeanSchema(BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItem, RuntimeValue<?> runtimeValue, String schemaId, Type type) {
        ParameterizedType providerType = ParameterizedType.create((DotName)DotNames.PULSAR_SCHEMA, (Type[])new Type[]{type});
        syntheticBeanBuildItem.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Object.class).providerType((Type)providerType)).addType((Type)providerType)).addQualifier().annotation(Identifier.class).addValue("value", (Object)schemaId).done()).scope(Dependent.class)).runtimeValue(runtimeValue).unremovable()).done());
    }

    void produceSyntheticBeanSchema(BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItem, Supplier<?> supplier, String schemaId, Type type) {
        ParameterizedType providerType = ParameterizedType.create((DotName)DotNames.PULSAR_SCHEMA, (Type[])new Type[]{type});
        syntheticBeanBuildItem.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Object.class).providerType((Type)providerType)).addType((Type)providerType)).addQualifier().annotation(Identifier.class).addValue("value", (Object)schemaId).done()).scope(Dependent.class)).supplier(supplier).unremovable()).done());
    }

    String generateId(Type type, String targetType) {
        String baseName = type.name().withoutPackagePrefix();
        return baseName + "_" + targetType + "Schema_" + HashUtil.sha1((String)Long.toString(UUID.randomUUID().getMostSignificantBits()));
    }
}

