/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.pulsar.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.pulsar.PulsarClientConfigCustomizer;
import io.quarkus.pulsar.PulsarRuntimeConfigProducer;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.DotNames;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class SmallRyeReactiveMessagingPulsarProcessor {
    static Logger log = Logger.getLogger(SmallRyeReactiveMessagingPulsarProcessor.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MESSAGING_PULSAR);
    }

    @BuildStep
    public AdditionalBeanBuildItem runtimeConfig() {
        return AdditionalBeanBuildItem.builder().addBeanClass(PulsarRuntimeConfigProducer.class).addBeanClass(PulsarClientConfigCustomizer.class).setUnremovable().build();
    }

    @BuildStep
    void logging(BuildProducer<LogCategoryBuildItem> log) {
        log.produce((BuildItem)new LogCategoryBuildItem("org.apache.pulsar.common.util.netty.DnsResolverUtil", Level.OFF));
    }

    @BuildStep
    void disableStatsLogging(BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfig) {
        runtimeConfig.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("mp.messaging.connector.smallrye-pulsar.statsIntervalSeconds", "0"));
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResources() {
        return new NativeImageResourceBuildItem(new String[]{"org/asynchttpclient/config/ahc-default.properties", "org/asynchttpclient/config/ahc.properties"});
    }

    @BuildStep
    void bytecodeTransformer(BuildProducer<BytecodeTransformerBuildItem> producer) {
        String klass = "org.asynchttpclient.request.body.multipart.FileLikePart";
        producer.produce((BuildItem)new BytecodeTransformerBuildItem(klass, (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

            @Override
            public ClassVisitor apply(String cls, ClassVisitor classVisitor) {
                return new FileLikePartJavaxRemover(589824, classVisitor);
            }
        }));
    }

    @BuildStep
    IndexDependencyBuildItem indexPulsar() {
        return new IndexDependencyBuildItem("org.apache.pulsar", "pulsar-client-original");
    }

    @BuildStep
    public NativeImageConfigBuildItem pulsarRuntimeInitialized(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ExtensionSslNativeSupportBuildItem> nativeSslSupport) {
        nativeSslSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.MESSAGING_PULSAR));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ClientConfigurationData.class.getName(), ProducerConfigurationData.class.getName(), ConsumerConfigurationData.class.getName(), "org.apache.pulsar.client.impl.auth.oauth2.KeyFile", "org.apache.pulsar.client.impl.auth.oauth2.protocol.Metadata", "org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenResult", "org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenError", "org.apache.pulsar.client.impl.auth.oauth2.protocol.ClientCredentialsExchangeRequest", "org.apache.pulsar.client.api.url.DataURLStreamHandler", "com.google.protobuf.GeneratedMessageV3", "org.apache.pulsar.common.protocol.schema.ProtobufNativeSchemaData", "org.apache.pulsar.client.impl.schema.ProtobufNativeSchema$ProtoBufParsingInfo", "org.apache.pulsar.client.impl.schema.ProtobufSchema$ProtoBufParsingInfo", "org.apache.pulsar.common.schema.KeyValue"}).fields(true).methods(true).constructors(true).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.apache.pulsar.client.util.SecretsSerializer"}).constructors().build());
        Collection authPluginClasses = combinedIndex.getIndex().getAllKnownImplementors(DotNames.PULSAR_AUTHENTICATION);
        for (ClassInfo authPluginClass : authPluginClasses) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{authPluginClass.name().toString()}).constructors().build());
        }
        NativeImageConfigBuildItem.Builder nativeImageConfig = NativeImageConfigBuildItem.builder().addNativeImageSystemProperty("io.netty.handler.ssl.noOpenSsl", "true").addRuntimeInitializedClass("org.apache.pulsar.common.allocator.PulsarByteBufAllocator").addRuntimeInitializedClass("org.apache.pulsar.common.protocol.Commands").addRuntimeInitializedClass("org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenClient").addRuntimeInitializedClass("org.apache.pulsar.client.impl.crypto.MessageCryptoBc").addRuntimeInitializedClass("org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema").addRuntimeInitializedClass("org.apache.pulsar.client.impl.ConnectionPool").addRuntimeInitializedClass("org.apache.pulsar.client.impl.ControlledClusterFailover").addRuntimeInitializedClass("org.apache.pulsar.client.impl.HttpClient").addRuntimeInitializedClass("org.apache.pulsar.client.util.WithSNISslEngineFactory").addRuntimeInitializedClass("com.yahoo.sketches.quantiles.DoublesSketch").addRuntimeInitializedClass("io.netty.buffer.PooledByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.UnpooledByteBufAllocator$InstrumentedUnpooledHeapByteBuf").addRuntimeInitializedClass("io.netty.incubator.channel.uring.IOUringEventLoopGroup").addRuntimeInitializedClass("io.netty.incubator.channel.uring.Native").addRuntimeInitializedClass("io.netty.incubator.channel.uring.IOUring").addRuntimeInitializedClass("org.asynchttpclient.RequestBuilderBase").addRuntimeInitializedClass("org.asynchttpclient.RequestBuilder").addRuntimeInitializedClass("org.asynchttpclient.BoundRequestBuilder").addRuntimeInitializedClass("org.asynchttpclient.ntlm.NtlmEngine").addRuntimeInitializedClass("sun.awt.dnd.SunDropTargetContextPeer$EventDispatcher");
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"org.apache.pulsar.common.util.Backoff")) {
            nativeImageConfig.addRuntimeInitializedClass("org.apache.pulsar.common.util.Backoff");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"org.apache.pulsar.client.impl.Backoff")) {
            nativeImageConfig.addRuntimeInitializedClass("org.apache.pulsar.client.impl.Backoff");
        }
        return nativeImageConfig.build();
    }

    private class FileLikePartJavaxRemover
    extends ClassVisitor {
        public FileLikePartJavaxRemover(int version, ClassVisitor cv) {
            super(version, cv);
            log.debug((Object)"Removing javax.activation from FileLikePart");
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (name.equals("MIME_TYPES_FILE_TYPE_MAP")) {
                return null;
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (visitor == null) {
                return null;
            }
            if (name.equals("<clinit>")) {
                return new MethodVisitor(589824, visitor){

                    public void visitCode() {
                        this.mv.visitCode();
                        this.mv.visitInsn(177);
                    }
                };
            }
            if (name.equals("computeContentType")) {
                return new MethodVisitor(589824, visitor){

                    public void visitCode() {
                        super.visitCode();
                        this.visitVarInsn(25, 1);
                        this.visitInsn(176);
                    }
                };
            }
            visitor.visitMaxs(0, 0);
            return visitor;
        }
    }
}

