/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.pulsar.deployment;

import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.PulsarBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.PulsarContainer;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.PulsarDevServicesBuildTimeConfig;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
public class PulsarDevServicesProcessor {
    private static final Logger log = Logger.getLogger(PulsarDevServicesProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-pulsar";
    private static final ContainerLocator pulsarContainerLocator = ContainerLocator.locateContainerWithLabels((int)6650, (String[])new String[]{"quarkus-dev-service-pulsar"});
    private static final String PULSAR_CLIENT_SERVICE_URL = "pulsar.client.serviceUrl";
    private static final String PULSAR_ADMIN_SERVICE_URL = "pulsar.admin.serviceUrl";
    static final String DEV_SERVICE_PULSAR = "pulsar";
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile PulsarDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startPulsarDevService(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, LaunchModeBuildItem launchMode, PulsarBuildTimeConfig pulsarClientBuildTimeConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig) {
        PulsarDevServiceCfg configuration = this.getConfiguration(pulsarClientBuildTimeConfig);
        boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.shutdownBroker();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Pulsar Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService newDevService = this.startPulsarContainer(dockerStatusBuildItem, composeProjectBuildItem, configuration, launchMode, useSharedNetwork, devServicesConfig.timeout());
            if (newDevService != null) {
                devService = newDevService;
                Map config = devService.getConfig();
                if (newDevService.isOwner()) {
                    log.info((Object)"Dev Services for Pulsar started.");
                    log.infof("Other Quarkus applications in dev mode will find the broker automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -Dpulsar.client.serviceUrl=%s", config.get(PULSAR_CLIENT_SERVICE_URL));
                }
            }
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownBroker();
                    log.info((Object)"Dev Services for Pulsar shut down.");
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        return devService.toBuildItem();
    }

    private void shutdownBroker() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Pulsar broker", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startPulsarContainer(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, PulsarDevServiceCfg config, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting Dev Services for Pulsar, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyNonEmpty((String)PULSAR_CLIENT_SERVICE_URL)) {
            log.debug((Object)"Not starting Dev Services for Pulsar, the pulsar.serviceUrl is configured.");
            return null;
        }
        if (!this.hasPulsarChannelWithoutHostAndPort()) {
            log.debug((Object)"Not starting Dev Services for Pulsar, all the channels are configured.");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the Pulsar broker location.");
            return null;
        }
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultPulsarBrokerSupplier = () -> {
            PulsarContainer container = new PulsarContainer(DockerImageName.parse((String)config.imageName).asCompatibleSubstituteFor("apachepulsar/pulsar"), composeProjectBuildItem.getDefaultNetworkId(), useSharedNetwork);
            config.brokerConfig.forEach((key, value) -> container.addEnv("PULSAR_PREFIX_" + key, (String)value));
            if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
                container.withLabel(DEV_SERVICE_LABEL, config.serviceName);
                container.withLabel("io.quarkus.devservice", config.serviceName);
            }
            if (config.fixedExposedPort != 0) {
                container.withPort(config.fixedExposedPort);
            }
            timeout.ifPresent(arg_0 -> ((PulsarContainer)container).withStartupTimeout(arg_0));
            container.start();
            return this.getRunningService(container.getContainerId(), () -> ((PulsarContainer)container).close(), container.getPulsarBrokerUrl(), container.getHttpServiceUrl());
        };
        return pulsarContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningService(containerAddress.getId(), null, this.getServiceUrl(containerAddress.getHost(), containerAddress.getPort()), this.getHttpServiceUrl(containerAddress.getHost(), pulsarContainerLocator.locatePublicPort(config.serviceName, config.shared, launchMode.getLaunchMode(), 8080).orElse(8080)))).or(() -> ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, List.of(config.imageName, DEV_SERVICE_PULSAR), (int)6650, (LaunchMode)launchMode.getLaunchMode(), (boolean)useSharedNetwork).map(this::getRunningService)).orElseGet(defaultPulsarBrokerSupplier);
    }

    private String getServiceUrl(String host, int port) {
        return String.format("pulsar://%s:%d", host, port);
    }

    private String getHttpServiceUrl(String host, int port) {
        return String.format("http://%s:%d", host, port);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningService(ContainerAddress address) {
        RunningContainer container = address.getRunningContainer();
        if (container == null) {
            return null;
        }
        int httpPort = container.getPortMapping(8080).orElse(8080);
        return this.getRunningService(address.getId(), null, this.getServiceUrl(address.getHost(), address.getPort()), this.getHttpServiceUrl(address.getHost(), httpPort));
    }

    private DevServicesResultBuildItem.RunningDevService getRunningService(String containerId, Closeable closeable, String pulsarBrokerUrl, String httpServiceUrl) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(PULSAR_CLIENT_SERVICE_URL, pulsarBrokerUrl);
        configMap.put(PULSAR_ADMIN_SERVICE_URL, httpServiceUrl);
        return new DevServicesResultBuildItem.RunningDevService(Feature.MESSAGING_PULSAR.getName(), containerId, closeable, configMap);
    }

    private boolean hasPulsarChannelWithoutHostAndPort() {
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            boolean isIncoming = name.startsWith("mp.messaging.incoming.");
            boolean isOutgoing = name.startsWith("mp.messaging.outgoing.");
            boolean isConnector = name.endsWith(".connector");
            boolean isConfigured = false;
            if ((isIncoming || isOutgoing) && isConnector) {
                String connectorValue = (String)config.getValue(name, String.class);
                boolean isPulsar = connectorValue.equalsIgnoreCase("smallrye-pulsar");
                boolean hasServiceUrl = ConfigUtils.isPropertyNonEmpty((String)name.replace(".connector", ".serviceUrl"));
                boolean bl = isConfigured = isPulsar && hasServiceUrl;
            }
            if (isConfigured) continue;
            return true;
        }
        return false;
    }

    private PulsarDevServiceCfg getConfiguration(PulsarBuildTimeConfig cfg) {
        PulsarDevServicesBuildTimeConfig devServicesConfig = cfg.devservices();
        return new PulsarDevServiceCfg(devServicesConfig);
    }

    static {
        first = true;
    }

    private static final class PulsarDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final Map<String, String> brokerConfig;

        public PulsarDevServiceCfg(PulsarDevServicesBuildTimeConfig devServicesConfig) {
            this.devServicesEnabled = devServicesConfig.enabled().orElse(true);
            this.imageName = devServicesConfig.imageName();
            this.fixedExposedPort = devServicesConfig.port().orElse(0);
            this.shared = devServicesConfig.shared();
            this.serviceName = devServicesConfig.serviceName();
            this.brokerConfig = devServicesConfig.brokerConfig();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PulsarDevServiceCfg that = (PulsarDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort) && Objects.equals(this.brokerConfig, that.brokerConfig);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort, this.brokerConfig);
        }
    }
}

