/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.pulsar.deployment;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.devservices.common.ConfigureUtil;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class PulsarContainer
extends GenericContainer<PulsarContainer> {
    public static final DockerImageName PULSAR_IMAGE = DockerImageName.parse((String)"apachepulsar/pulsar:3.2.4");
    public static final String STARTER_SCRIPT = "/run_pulsar.sh";
    public static final int BROKER_PORT = 6650;
    public static final int BROKER_HTTP_PORT = 8080;
    private boolean useSharedNetwork;
    private String hostName;

    public PulsarContainer() {
        this(PULSAR_IMAGE);
    }

    public PulsarContainer(DockerImageName imageName) {
        super(imageName);
        super.withExposedPorts(new Integer[]{6650, 8080});
        super.withStartupTimeout(Duration.ofSeconds(60L));
        super.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Created namespace public/default.*", (int)1));
        super.withCommand(new String[]{"sh", "-c", this.runStarterScript()});
        super.withTmpFs(Collections.singletonMap("/pulsar/data", "rw"));
    }

    protected String runStarterScript() {
        return "while [ ! -x /run_pulsar.sh ]; do sleep 0.1; done; /run_pulsar.sh";
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        String advertisedListeners = String.format("internal:pulsar://localhost:%s,external:pulsar://%s:%s", 6650, this.getHost(), this.getMappedPort(6650));
        Object command = "#!/bin/bash \n";
        command = (String)command + "export PULSAR_PREFIX_advertisedListeners=" + advertisedListeners + " \n";
        command = (String)command + "bin/apply-config-from-env.py conf/standalone.conf && bin/pulsar standalone -nfw -nss";
        this.copyFileToContainer(Transferable.of((byte[])((String)command).getBytes(StandardCharsets.UTF_8), (int)700), STARTER_SCRIPT);
    }

    public PulsarContainer withSharedNetwork() {
        this.useSharedNetwork = true;
        this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"pulsar");
        return (PulsarContainer)this.self();
    }

    public PulsarContainer withPort(int fixedPort) {
        if (fixedPort <= 0) {
            throw new IllegalArgumentException("The fixed port must be greater than 0");
        }
        this.addFixedExposedPort(fixedPort, 6650);
        return (PulsarContainer)this.self();
    }

    public String getPulsarBrokerUrl() {
        if (this.useSharedNetwork) {
            return this.getServiceUrl(this.hostName, 6650);
        }
        return this.getServiceUrl(this.getHost(), this.getMappedPort(6650));
    }

    private String getServiceUrl(String host, int port) {
        return String.format("pulsar://%s:%d", host, port);
    }

    public String getHttpServiceUrl() {
        if (this.useSharedNetwork) {
            return this.getHttpServiceUrl(this.hostName, 8080);
        }
        return this.getHttpServiceUrl(this.getHost(), this.getMappedPort(8080));
    }

    private String getHttpServiceUrl(String host, int port) {
        return String.format("http://%s:%d", host, port);
    }
}

