/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem;
import io.quarkus.kafka.client.serialization.BufferDeserializer;
import io.quarkus.kafka.client.serialization.BufferSerializer;
import io.quarkus.kafka.client.serialization.JsonArrayDeserializer;
import io.quarkus.kafka.client.serialization.JsonArraySerializer;
import io.quarkus.kafka.client.serialization.JsonObjectDeserializer;
import io.quarkus.kafka.client.serialization.JsonObjectSerializer;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorManagedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.kafka.DatabindProcessingStateCodec;
import io.quarkus.smallrye.reactivemessaging.kafka.HibernateOrmStateStore;
import io.quarkus.smallrye.reactivemessaging.kafka.HibernateReactiveStateStore;
import io.quarkus.smallrye.reactivemessaging.kafka.KafkaConfigCustomizer;
import io.quarkus.smallrye.reactivemessaging.kafka.RedisStateStore;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.DefaultSerdeDiscoveryState;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.DotNames;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.JacksonSerdeGenerator;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.ReactiveMessagingKafkaBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.kafka.deployment.Result;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingState;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;
import org.apache.kafka.common.serialization.UUIDSerializer;
import org.apache.kafka.common.serialization.VoidDeserializer;
import org.apache.kafka.common.serialization.VoidSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeReactiveMessagingKafkaProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.smallrye-reactive-messaging-kafka.deployment.processor");
    public static final String CHECKPOINT_STATE_STORE_MESSAGE = "Quarkus detected the use of `%s` for the Kafka checkpoint commit strategy but the extension has not been added. Consider adding '%s'.";
    private static final String CHECKPOINT_ENTITY_NAME = "io.quarkus.smallrye.reactivemessaging.kafka.CheckpointEntity";
    private static final String CHECKPOINT_ENTITY_ID_NAME = "io.quarkus.smallrye.reactivemessaging.kafka.CheckpointEntityId";
    static String channelPropertyFormat = "mp.messaging.%s.%s.%s";
    private static final Map<DotName, String> KNOWN_DESERIALIZERS = Map.ofEntries(Map.entry(DotName.createSimple((String)"short"), ShortDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"int"), IntegerDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"long"), LongDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"float"), FloatDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"double"), DoubleDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Short.class.getName()), ShortDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Integer.class.getName()), IntegerDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Long.class.getName()), LongDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Float.class.getName()), FloatDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Double.class.getName()), DoubleDeserializer.class.getName()), Map.entry(DotName.createSimple((String)"[B"), ByteArrayDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Void.class.getName()), VoidDeserializer.class.getName()), Map.entry(DotName.createSimple((String)String.class.getName()), StringDeserializer.class.getName()), Map.entry(DotName.createSimple((String)UUID.class.getName()), UUIDDeserializer.class.getName()), Map.entry(DotName.createSimple((String)ByteBuffer.class.getName()), ByteBufferDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Bytes.class.getName()), BytesDeserializer.class.getName()), Map.entry(DotName.createSimple((String)Buffer.class.getName()), BufferDeserializer.class.getName()), Map.entry(DotName.createSimple((String)JsonObject.class.getName()), JsonObjectDeserializer.class.getName()), Map.entry(DotName.createSimple((String)JsonArray.class.getName()), JsonArrayDeserializer.class.getName()));
    private static final Map<DotName, String> KNOWN_SERIALIZERS = Map.ofEntries(Map.entry(DotName.createSimple((String)"short"), ShortSerializer.class.getName()), Map.entry(DotName.createSimple((String)"int"), IntegerSerializer.class.getName()), Map.entry(DotName.createSimple((String)"long"), LongSerializer.class.getName()), Map.entry(DotName.createSimple((String)"float"), FloatSerializer.class.getName()), Map.entry(DotName.createSimple((String)"double"), DoubleSerializer.class.getName()), Map.entry(DotName.createSimple((String)Short.class.getName()), ShortSerializer.class.getName()), Map.entry(DotName.createSimple((String)Integer.class.getName()), IntegerSerializer.class.getName()), Map.entry(DotName.createSimple((String)Long.class.getName()), LongSerializer.class.getName()), Map.entry(DotName.createSimple((String)Float.class.getName()), FloatSerializer.class.getName()), Map.entry(DotName.createSimple((String)Double.class.getName()), DoubleSerializer.class.getName()), Map.entry(DotName.createSimple((String)"[B"), ByteArraySerializer.class.getName()), Map.entry(DotName.createSimple((String)Void.class.getName()), VoidSerializer.class.getName()), Map.entry(DotName.createSimple((String)String.class.getName()), StringSerializer.class.getName()), Map.entry(DotName.createSimple((String)UUID.class.getName()), UUIDSerializer.class.getName()), Map.entry(DotName.createSimple((String)ByteBuffer.class.getName()), ByteBufferSerializer.class.getName()), Map.entry(DotName.createSimple((String)Bytes.class.getName()), BytesSerializer.class.getName()), Map.entry(DotName.createSimple((String)Buffer.class.getName()), BufferSerializer.class.getName()), Map.entry(DotName.createSimple((String)JsonObject.class.getName()), JsonObjectSerializer.class.getName()), Map.entry(DotName.createSimple((String)JsonArray.class.getName()), JsonArraySerializer.class.getName()));

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MESSAGING_KAFKA);
    }

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ProcessingState.class}).reason(this.getClass().getName()).methods().fields().build());
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KafkaConfigCustomizer.class));
    }

    @BuildStep
    public void ignoreDuplicateJmxRegistrationInDevAndTestModes(LaunchModeBuildItem launchMode, BuildProducer<LogCleanupFilterBuildItem> log) {
        if (launchMode.getLaunchMode().isDevOrTest()) {
            log.produce((BuildItem)new LogCleanupFilterBuildItem("org.apache.kafka.common.utils.AppInfoParser", new String[]{"Error registering AppInfo mbean"}));
        }
    }

    static boolean hasStateStoreConfig(String stateStoreName, Config config) {
        Optional<String> connectorStrategy = SmallRyeReactiveMessagingKafkaProcessor.getConnectorProperty("checkpoint.state-store", config);
        if (connectorStrategy.isPresent() && connectorStrategy.get().equals(stateStoreName)) {
            return true;
        }
        List<String> stateStores = SmallRyeReactiveMessagingKafkaProcessor.getChannelProperties("checkpoint.state-store", config);
        return stateStores.contains(stateStoreName);
    }

    static boolean hasDLQConfig(String channelName, Config config) {
        String propertyKey = SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "failure-strategy", true);
        Optional channelFailureStrategy = config.getOptionalValue(propertyKey, String.class);
        Optional failureStrategy = channelFailureStrategy.or(() -> SmallRyeReactiveMessagingKafkaProcessor.getConnectorProperty("failure-strategy", config));
        return failureStrategy.isPresent() && (((String)failureStrategy.get()).equals("dead-letter-queue") || ((String)failureStrategy.get()).equals("delayed-retry-topic"));
    }

    private static Optional<String> getConnectorProperty(String keySuffix, Config config) {
        return config.getOptionalValue("mp.messaging.connector.smallrye-kafka." + keySuffix, String.class);
    }

    private static List<String> getChannelProperties(String keySuffix, Config config) {
        ArrayList<String> values = new ArrayList<String>();
        for (String propertyName : config.getPropertyNames()) {
            if (!propertyName.startsWith("mp.messaging.incoming.") || !propertyName.endsWith("." + keySuffix)) continue;
            values.add((String)config.getValue(propertyName, String.class));
        }
        return values;
    }

    static String getChannelPropertyKey(String channelName, String propertyName, boolean incoming) {
        return String.format(channelPropertyFormat, incoming ? "incoming" : "outgoing", channelName.contains(".") ? "\"" + channelName + "\"" : channelName, propertyName);
    }

    @BuildStep
    public void checkpointRedis(BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Capabilities capabilities) {
        if (SmallRyeReactiveMessagingKafkaProcessor.hasStateStoreConfig("quarkus-redis", ConfigProvider.getConfig())) {
            Optional<String> checkpointStateType = SmallRyeReactiveMessagingKafkaProcessor.getConnectorProperty("checkpoint.state-type", ConfigProvider.getConfig());
            checkpointStateType.ifPresent(s -> reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{s}).reason(this.getClass().getName()).methods().fields().build()));
            if (capabilities.isPresent("io.quarkus.redis")) {
                additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RedisStateStore.Factory.class}));
                additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DatabindProcessingStateCodec.Factory.class}));
            } else {
                LOGGER.warnf(CHECKPOINT_STATE_STORE_MESSAGE, (Object)"quarkus-redis", (Object)"quarkus-redis-client");
            }
        }
    }

    @BuildStep
    public void checkpointHibernateReactive(BuildProducer<AdditionalBeanBuildItem> additionalBean, Capabilities capabilities) {
        if (SmallRyeReactiveMessagingKafkaProcessor.hasStateStoreConfig("quarkus-hibernate-reactive", ConfigProvider.getConfig())) {
            if (capabilities.isPresent("io.quarkus.hibernate.reactive")) {
                additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HibernateReactiveStateStore.Factory.class}));
            } else {
                LOGGER.warnf(CHECKPOINT_STATE_STORE_MESSAGE, (Object)"quarkus-hibernate-reactive", (Object)"quarkus-hibernate-reactive");
            }
        }
    }

    @BuildStep
    public void checkpointHibernateOrm(BuildProducer<AdditionalBeanBuildItem> additionalBean, Capabilities capabilities) {
        if (SmallRyeReactiveMessagingKafkaProcessor.hasStateStoreConfig("quarkus-hibernate-orm", ConfigProvider.getConfig())) {
            if (capabilities.isPresent("io.quarkus.hibernate.orm")) {
                additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HibernateOrmStateStore.Factory.class}));
            } else {
                LOGGER.warnf(CHECKPOINT_STATE_STORE_MESSAGE, (Object)"quarkus-hibernate-orm", (Object)"quarkus-hibernate-orm");
            }
        }
    }

    @BuildStep
    public void additionalJpaModel(BuildProducer<AdditionalJpaModelBuildItem> additionalJpaModel) {
        additionalJpaModel.produce((BuildItem)new AdditionalJpaModelBuildItem(CHECKPOINT_ENTITY_NAME));
        additionalJpaModel.produce((BuildItem)new AdditionalJpaModelBuildItem(CHECKPOINT_ENTITY_ID_NAME));
    }

    @BuildStep
    public void defaultChannelConfiguration(LaunchModeBuildItem launchMode, ReactiveMessagingKafkaBuildTimeConfig buildTimeConfig, CombinedIndexBuildItem combinedIndex, List<ConnectorManagedChannelBuildItem> channelsManagedByConnectors, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigProducer, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflection) {
        DefaultSerdeDiscoveryState discoveryState = new DefaultSerdeDiscoveryState(combinedIndex.getIndex());
        if (buildTimeConfig.serializerAutodetectionEnabled()) {
            this.discoverDefaultSerdeConfig(discoveryState, channelsManagedByConnectors, defaultConfigProducer, (BuildProducer<GeneratedClassBuildItem>)(buildTimeConfig.serializerGenerationEnabled() ? generatedClass : null), reflection);
        }
        if (launchMode.getLaunchMode().isDevOrTest() && !buildTimeConfig.enableGracefulShutdownInDevAndTestMode()) {
            List<AnnotationInstance> incomings = discoveryState.findRepeatableAnnotationsOnMethods(DotNames.INCOMING);
            List<AnnotationInstance> outgoings = discoveryState.findRepeatableAnnotationsOnMethods(DotNames.OUTGOING);
            List<AnnotationInstance> channels = discoveryState.findAnnotationsOnInjectionPoints(DotNames.CHANNEL);
            ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
            annotations.addAll(incomings);
            annotations.addAll(outgoings);
            annotations.addAll(channels);
            for (AnnotationInstance annotation : annotations) {
                String channelName = annotation.value().asString();
                if (!discoveryState.isKafkaConnector(channelsManagedByConnectors, true, channelName)) continue;
                String key = SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "graceful-shutdown", true);
                discoveryState.ifNotYetConfigured(key, () -> defaultConfigProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(key, "false")));
            }
        }
    }

    void discoverDefaultSerdeConfig(DefaultSerdeDiscoveryState discovery, List<ConnectorManagedChannelBuildItem> channelsManagedByConnectors, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflection) {
        Type incomingType;
        MethodInfo method;
        String channelName;
        HashMap<String, Result> alreadyGeneratedSerializers = new HashMap<String, Result>();
        HashMap<String, Result> alreadyGeneratedDeserializers = new HashMap<String, Result>();
        for (AnnotationInstance annotation : discovery.findRepeatableAnnotationsOnMethods(DotNames.INCOMING)) {
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(channelsManagedByConnectors, true, channelName)) continue;
            method = annotation.target().asMethod();
            incomingType = this.getIncomingTypeFromMethod(method);
            this.processIncomingType(discovery, config, incomingType, channelName, generatedClass, reflection, alreadyGeneratedDeserializers, alreadyGeneratedSerializers);
        }
        for (AnnotationInstance annotation : discovery.findRepeatableAnnotationsOnMethods(DotNames.OUTGOING)) {
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(channelsManagedByConnectors, false, channelName)) continue;
            method = annotation.target().asMethod();
            Type outgoingType = this.getOutgoingTypeFromMethod(method);
            this.processOutgoingType(discovery, outgoingType, (keySerializer, valueSerializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "key.serializer", false), (Result)keySerializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "value.serializer", false), (Result)valueSerializer);
                this.handleAdditionalProperties(channelName, false, discovery, config, (Result)keySerializer, (Result)valueSerializer);
            }, generatedClass, reflection, alreadyGeneratedSerializers);
        }
        for (AnnotationInstance annotation : discovery.findAnnotationsOnInjectionPoints(DotNames.CHANNEL)) {
            Type injectionPointType;
            channelName = annotation.value().asString();
            if (!discovery.isKafkaConnector(channelsManagedByConnectors, false, channelName) && !discovery.isKafkaConnector(channelsManagedByConnectors, true, channelName) || (injectionPointType = this.getInjectionPointType(annotation)) == null) continue;
            incomingType = this.getIncomingTypeFromChannelInjectionPoint(injectionPointType);
            this.processIncomingType(discovery, config, incomingType, channelName, generatedClass, reflection, alreadyGeneratedDeserializers, alreadyGeneratedSerializers);
            this.processKafkaTransactions(discovery, config, channelName, injectionPointType);
            if (SmallRyeReactiveMessagingKafkaProcessor.isKafkaRequestReplyEmitter(injectionPointType)) {
                Type requestType = (Type)injectionPointType.asParameterizedType().arguments().get(0);
                Type replyType = (Type)injectionPointType.asParameterizedType().arguments().get(1);
                this.processOutgoingType(discovery, requestType, (keySerializer, valueSerializer) -> {
                    this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "key.serializer", false), (Result)keySerializer);
                    this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "value.serializer", false), (Result)valueSerializer);
                }, generatedClass, reflection, alreadyGeneratedSerializers);
                this.extractKeyValueType(replyType, (Functions.TriConsumer<Type, Type, Boolean>)((Functions.TriConsumer)(key, value, isBatchType) -> {
                    Result keyDeserializer = this.deserializerFor(discovery, (Type)key, true, channelName, generatedClass, reflection, (Map<String, Result>)alreadyGeneratedDeserializers, (Map<String, Result>)alreadyGeneratedSerializers);
                    Result valueDeserializer = this.deserializerFor(discovery, (Type)value, false, channelName, generatedClass, reflection, (Map<String, Result>)alreadyGeneratedDeserializers, (Map<String, Result>)alreadyGeneratedSerializers);
                    this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "reply.key.deserializer", false), keyDeserializer);
                    this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "reply.value.deserializer", false), valueDeserializer);
                    this.handleAdditionalProperties(channelName, false, discovery, config, keyDeserializer, valueDeserializer);
                }));
                continue;
            }
            Type outgoingType = this.getOutgoingTypeFromChannelInjectionPoint(injectionPointType);
            this.processOutgoingType(discovery, outgoingType, (keySerializer, valueSerializer) -> {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "key.serializer", false), (Result)keySerializer);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "value.serializer", false), (Result)valueSerializer);
                this.handleAdditionalProperties(channelName, false, discovery, config, (Result)keySerializer, (Result)valueSerializer);
            }, generatedClass, reflection, alreadyGeneratedSerializers);
        }
    }

    private void processKafkaTransactions(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String channelName, Type injectionPointType) {
        if (injectionPointType != null && SmallRyeReactiveMessagingKafkaProcessor.isKafkaTransactionsEmitter(injectionPointType)) {
            String transactionalIdKey = SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "transactional.id", false);
            String enableIdempotenceKey = SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "enable.idempotence", false);
            String acksKey = SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "acks", false);
            LOGGER.infof("Transactional producer detected for channel '%s', setting following default config values: '" + transactionalIdKey + "=${quarkus.application.name}-${channelName}', '" + enableIdempotenceKey + "=true', '" + acksKey + "=all'", (Object)channelName);
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, transactionalIdKey, "${quarkus.application.name}-" + channelName);
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, enableIdempotenceKey, "true");
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, acksKey, "all");
        }
    }

    private void processIncomingType(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, Type incomingType, String channelName, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflection, Map<String, Result> alreadyGeneratedDeserializers, Map<String, Result> alreadyGeneratedSerializers) {
        this.extractKeyValueType(incomingType, (Functions.TriConsumer<Type, Type, Boolean>)((Functions.TriConsumer)(key, value, isBatchType) -> {
            Result keyDeserializer = this.deserializerFor(discovery, (Type)key, true, channelName, generatedClass, reflection, alreadyGeneratedDeserializers, alreadyGeneratedSerializers);
            Result valueDeserializer = this.deserializerFor(discovery, (Type)value, false, channelName, generatedClass, reflection, alreadyGeneratedDeserializers, alreadyGeneratedSerializers);
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "key.deserializer", true), keyDeserializer);
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "value.deserializer", true), valueDeserializer);
            if (Boolean.TRUE.equals(isBatchType)) {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, "batch", true), "true");
            }
            this.handleAdditionalProperties(channelName, true, discovery, config, keyDeserializer, valueDeserializer);
        }));
    }

    private Type getInjectionPointType(AnnotationInstance annotation) {
        return switch (annotation.target().kind()) {
            case AnnotationTarget.Kind.FIELD -> this.handleInstanceChannelInjection(annotation.target().asField().type());
            case AnnotationTarget.Kind.METHOD_PARAMETER -> this.handleInstanceChannelInjection(annotation.target().asMethodParameter().type());
            default -> null;
        };
    }

    private Type handleInstanceChannelInjection(Type type) {
        return DotNames.INSTANCE.equals((Object)type.name()) || DotNames.PROVIDER.equals((Object)type.name()) || DotNames.INJECTABLE_INSTANCE.equals((Object)type.name()) ? (Type)type.asParameterizedType().arguments().get(0) : type;
    }

    private void handleAdditionalProperties(String channelName, boolean incoming, DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, Result ... results) {
        for (Result result : results) {
            if (result == null) continue;
            result.additionalProperties.forEach((key, value) -> {
                String configKey = SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, key, incoming);
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, configKey, (String)value);
            });
        }
    }

    private void produceRuntimeConfigurationDefaultBuildItem(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String key, Result result) {
        if (result == null) {
            return;
        }
        this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, key, result.value);
    }

    private void produceRuntimeConfigurationDefaultBuildItem(DefaultSerdeDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String key, String value) {
        if (value == null) {
            return;
        }
        if (discovery.shouldNotConfigure(key)) {
            return;
        }
        discovery.ifNotYetConfigured(key, () -> config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(key, value)));
    }

    private Type getIncomingTypeFromMethod(MethodInfo method) {
        List parameterTypes = method.parameterTypes();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type incomingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isVoid(returnType) && parametersCount >= 1 || SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount >= 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount >= 1) {
            incomingType = (Type)parameterTypes.get(0);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isSubscriber(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isSubscriberBuilder(returnType) && parametersCount == 0) {
            incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
        } else if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            incomingType = (Type)parameterTypes.get(0);
        }
        if (method.hasAnnotation(DotNames.OUTGOING) || method.hasAnnotation(DotNames.OUTGOINGS)) {
            if (SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount >= 1 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount >= 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isFlowPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 1) {
                incomingType = (Type)parameterTypes.get(0);
            } else if (SmallRyeReactiveMessagingKafkaProcessor.isProcessor(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isProcessorBuilder(returnType) && parametersCount == 0) {
                incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
            } else if (parametersCount >= 1) {
                incomingType = (Type)parameterTypes.get(0);
            } else if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
                incomingType = (Type)parameterTypes.get(0);
            }
            if (incomingType != null && (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isFlowPublisher(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(incomingType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(incomingType))) {
                incomingType = (Type)incomingType.asParameterizedType().arguments().get(0);
            }
        }
        return incomingType;
    }

    private Type getIncomingTypeFromChannelInjectionPoint(Type injectionPointType) {
        if (injectionPointType == null) {
            return null;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isFlowPublisher(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(injectionPointType)) {
            return (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    private Type getOutgoingTypeFromMethod(MethodInfo method) {
        List parameterTypes = method.parameterTypes();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type outgoingType = null;
        if (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isFlowPublisher(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isMultiSplitter(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) && parametersCount == 0) {
            outgoingType = (Type)returnType.asParameterizedType().arguments().get(0);
        } else if (parametersCount == 0) {
            outgoingType = returnType;
        } else if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            outgoingType = SmallRyeReactiveMessagingKafkaProcessor.getReturnTypeFromKotlinSuspendMethod(method);
        }
        if ((method.hasAnnotation(DotNames.INCOMING) || method.hasAnnotation(DotNames.INCOMINGS)) && (outgoingType = SmallRyeReactiveMessagingKafkaProcessor.isCompletionStage(returnType) || SmallRyeReactiveMessagingKafkaProcessor.isUni(returnType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(returnType) ? (Type)returnType.asParameterizedType().arguments().get(0) : (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isFlowPublisher(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || SmallRyeReactiveMessagingKafkaProcessor.isMultiSplitter(returnType) && parametersCount == 1 ? (Type)returnType.asParameterizedType().arguments().get(0) : (SmallRyeReactiveMessagingKafkaProcessor.isProcessor(returnType) && parametersCount == 0 || SmallRyeReactiveMessagingKafkaProcessor.isProcessorBuilder(returnType) && parametersCount == 0 ? (Type)returnType.asParameterizedType().arguments().get(1) : (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method) ? SmallRyeReactiveMessagingKafkaProcessor.getReturnTypeFromKotlinSuspendMethod(method) : returnType)))) != null && (SmallRyeReactiveMessagingKafkaProcessor.isPublisher(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isFlowPublisher(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isPublisherBuilder(outgoingType) || SmallRyeReactiveMessagingKafkaProcessor.isMulti(outgoingType))) {
            outgoingType = (Type)outgoingType.asParameterizedType().arguments().get(0);
        }
        return outgoingType;
    }

    private static Type getReturnTypeFromKotlinSuspendMethod(MethodInfo method) {
        Type firstGenericType;
        Type continuationReturnType = method.parameterType(method.parametersCount() - 1);
        if (continuationReturnType.kind() == Type.Kind.PARAMETERIZED_TYPE && (firstGenericType = (Type)continuationReturnType.asParameterizedType().arguments().get(0)).kind() == Type.Kind.WILDCARD_TYPE) {
            return firstGenericType.asWildcardType().superBound();
        }
        return null;
    }

    private Type getOutgoingTypeFromChannelInjectionPoint(Type injectionPointType) {
        if (injectionPointType == null) {
            return null;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isEmitter(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isMutinyEmitter(injectionPointType) || SmallRyeReactiveMessagingKafkaProcessor.isKafkaTransactionsEmitter(injectionPointType)) {
            return (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    private void processOutgoingType(DefaultSerdeDiscoveryState discovery, Type outgoingType, BiConsumer<Result, Result> serializerAcceptor, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflection, Map<String, Result> alreadyGeneratedSerializer) {
        this.extractKeyValueType(outgoingType, (Functions.TriConsumer<Type, Type, Boolean>)((Functions.TriConsumer)(key, value, isBatch) -> {
            Result keySerializer = this.serializerFor(discovery, (Type)key, generatedClass, reflection, alreadyGeneratedSerializer);
            Result valueSerializer = this.serializerFor(discovery, (Type)value, generatedClass, reflection, alreadyGeneratedSerializer);
            serializerAcceptor.accept(keySerializer, valueSerializer);
        }));
    }

    private void extractKeyValueType(Type type, Functions.TriConsumer<Type, Type, Boolean> keyValueTypeAcceptor) {
        if (type == null) {
            return;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isTargeted(type)) {
            return;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isGenericPayload(type)) {
            this.extractKeyValueType((Type)type.asParameterizedType().arguments().get(0), keyValueTypeAcceptor);
            return;
        }
        if (SmallRyeReactiveMessagingKafkaProcessor.isMessage(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            Type messageTypeParameter = (Type)typeArguments.get(0);
            if (SmallRyeReactiveMessagingKafkaProcessor.isList(messageTypeParameter)) {
                List messageListTypeArguments = messageTypeParameter.asParameterizedType().arguments();
                keyValueTypeAcceptor.accept(null, (Object)((Type)messageListTypeArguments.get(0)), (Object)true);
            } else {
                keyValueTypeAcceptor.accept(null, (Object)messageTypeParameter, (Object)false);
            }
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isList(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            keyValueTypeAcceptor.accept(null, (Object)((Type)typeArguments.get(0)), (Object)true);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isKafkaRecord(type) || SmallRyeReactiveMessagingKafkaProcessor.isRecord(type) || SmallRyeReactiveMessagingKafkaProcessor.isProducerRecord(type) || SmallRyeReactiveMessagingKafkaProcessor.isConsumerRecord(type) || SmallRyeReactiveMessagingKafkaProcessor.isKeyedMulti(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            keyValueTypeAcceptor.accept((Object)((Type)typeArguments.get(0)), (Object)((Type)typeArguments.get(1)), (Object)false);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isConsumerRecords(type) || SmallRyeReactiveMessagingKafkaProcessor.isKafkaBatchRecord(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            keyValueTypeAcceptor.accept((Object)((Type)typeArguments.get(0)), (Object)((Type)typeArguments.get(1)), (Object)true);
        } else if (SmallRyeReactiveMessagingKafkaProcessor.isRawMessage(type)) {
            keyValueTypeAcceptor.accept(null, (Object)type, (Object)false);
        }
    }

    private static boolean isVoid(Type type) {
        return type.kind() == Type.Kind.VOID;
    }

    private static boolean isCompletionStage(Type type) {
        return DotNames.COMPLETION_STAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isUni(Type type) {
        return DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMulti(Type type) {
        return DotNames.MULTI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMultiSplitter(Type type) {
        return DotNames.MULTI_SPLITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isSubscriber(Type type) {
        return DotNames.SUBSCRIBER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isSubscriberBuilder(Type type) {
        return DotNames.SUBSCRIBER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isPublisher(Type type) {
        return DotNames.PUBLISHER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isFlowPublisher(Type type) {
        return DotNames.FLOW_PUBLISHER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPublisherBuilder(Type type) {
        return DotNames.PUBLISHER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isProcessor(Type type) {
        return DotNames.PROCESSOR.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isProcessorBuilder(Type type) {
        return DotNames.PROCESSOR_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isEmitter(Type type) {
        return DotNames.EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMutinyEmitter(Type type) {
        return DotNames.MUTINY_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKafkaTransactionsEmitter(Type type) {
        return DotNames.KAFKA_TRANSACTIONS_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKafkaRequestReplyEmitter(Type type) {
        return DotNames.KAFKA_REQUEST_REPLY_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isMessage(Type type) {
        return DotNames.MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isGenericPayload(Type type) {
        return DotNames.GENERIC_PAYLOAD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKafkaRecord(Type type) {
        return DotNames.KAFKA_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isRecord(Type type) {
        return DotNames.RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isConsumerRecord(Type type) {
        return DotNames.CONSUMER_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isKeyedMulti(Type type) {
        return ReactiveMessagingDotNames.KEYED_MULTI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isProducerRecord(Type type) {
        return DotNames.PRODUCER_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isList(Type type) {
        return DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKafkaBatchRecord(Type type) {
        return DotNames.KAFKA_BATCH_RECORD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isConsumerRecords(Type type) {
        return DotNames.CONSUMER_RECORDS.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isTargeted(Type type) {
        return DotNames.TARGETED.equals((Object)type.name()) || DotNames.TARGETED_MESSAGES.equals((Object)type.name());
    }

    private static boolean isRawMessage(Type type) {
        switch (type.kind()) {
            case PRIMITIVE: 
            case CLASS: 
            case ARRAY: {
                return true;
            }
        }
        return false;
    }

    private Result deserializerFor(DefaultSerdeDiscoveryState discovery, Type type, boolean key, String channelName, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflection, Map<String, Result> alreadyGeneratedDeserializers, Map<String, Result> alreadyGeneratedSerializers) {
        Result result = this.serializerDeserializerFor(discovery, type, false);
        if (result != null && !result.exists) {
            return null;
        }
        if (result == null && type != null && generatedClass != null && type.kind() == Type.Kind.CLASS && (result = alreadyGeneratedDeserializers.get(type.toString())) == null) {
            String clazz = JacksonSerdeGenerator.generateDeserializer(generatedClass, type);
            LOGGER.infof("Generating Jackson deserializer for type %s", (Object)type.name().toString());
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{clazz}).reason(this.getClass().getName()).methods().build());
            alreadyGeneratedDeserializers.put(type.toString(), result);
            if (SmallRyeReactiveMessagingKafkaProcessor.hasDLQConfig(channelName, discovery.getConfig())) {
                Result serializer = this.serializerFor(discovery, type, generatedClass, reflection, alreadyGeneratedSerializers);
                if (serializer != null) {
                    result = Result.of(clazz).with(key, "dead-letter-queue.key.serializer", serializer.value).with(!key, "dead-letter-queue.value.serializer", serializer.value);
                }
            } else {
                result = Result.of(clazz);
            }
        }
        return result;
    }

    private Result serializerFor(DefaultSerdeDiscoveryState discovery, Type type, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflection, Map<String, Result> alreadyGeneratedSerializers) {
        Result result = this.serializerDeserializerFor(discovery, type, true);
        if (result != null && !result.exists) {
            return null;
        }
        if (result == null && type != null && generatedClass != null && type.kind() == Type.Kind.CLASS && (result = alreadyGeneratedSerializers.get(type.toString())) == null) {
            String clazz = JacksonSerdeGenerator.generateSerializer(generatedClass, type);
            LOGGER.infof("Generating Jackson serializer for type %s", (Object)type.name().toString());
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{clazz}).reason(this.getClass().getName()).methods().build());
            result = Result.of(clazz);
            alreadyGeneratedSerializers.put(type.toString(), result);
        }
        return result;
    }

    private Result serializerDeserializerFor(DefaultSerdeDiscoveryState discovery, Type type, boolean serializer) {
        Map<DotName, String> map;
        DotName typeName;
        if (type == null) {
            return null;
        }
        ClassInfo implementation = discovery.getImplementorOfWithTypeArgument(serializer ? DotNames.KAFKA_SERIALIZER : DotNames.KAFKA_DESERIALIZER, typeName = type.name());
        if (implementation != null) {
            return Result.of(implementation.name().toString());
        }
        Map<DotName, String> map2 = map = serializer ? KNOWN_SERIALIZERS : KNOWN_DESERIALIZERS;
        if (map.containsKey(typeName)) {
            return Result.of(map.get(typeName));
        }
        boolean isAvroGenerated = discovery.isAvroGenerated(typeName);
        if (isAvroGenerated || DotNames.AVRO_GENERIC_RECORD.equals((Object)typeName)) {
            int avroLibraries = 0;
            avroLibraries += discovery.hasConfluent() ? 1 : 0;
            avroLibraries += discovery.hasApicurio1() ? 1 : 0;
            if ((avroLibraries += discovery.hasApicurio2Avro() ? 1 : 0) > 1) {
                LOGGER.debugf("Skipping Avro serde autodetection for %s, because multiple Avro serde libraries are present", (Object)typeName);
                return Result.nonexistent();
            }
            if (discovery.hasConfluent()) {
                return serializer ? Result.of("io.confluent.kafka.serializers.KafkaAvroSerializer") : Result.of("io.confluent.kafka.serializers.KafkaAvroDeserializer").with(isAvroGenerated, "specific.avro.reader", "true");
            }
            if (discovery.hasApicurio1()) {
                return serializer ? Result.of("io.apicurio.registry.utils.serde.AvroKafkaSerializer") : Result.of("io.apicurio.registry.utils.serde.AvroKafkaDeserializer").with(isAvroGenerated, "apicurio.registry.use-specific-avro-reader", "true");
            }
            if (discovery.hasApicurio2Avro()) {
                return serializer ? Result.of("io.apicurio.registry.serde.avro.AvroKafkaSerializer") : Result.of("io.apicurio.registry.serde.avro.AvroKafkaDeserializer").with(isAvroGenerated, "apicurio.registry.use-specific-avro-reader", "true");
            }
            return Result.nonexistent();
        }
        ClassInfo subclass = discovery.getSubclassOfWithTypeArgument(serializer ? DotNames.OBJECT_MAPPER_SERIALIZER : DotNames.OBJECT_MAPPER_DESERIALIZER, typeName);
        if (subclass != null) {
            return Result.of(subclass.name().toString());
        }
        if (discovery.hasJsonb() && (subclass = discovery.getSubclassOfWithTypeArgument(serializer ? DotNames.JSONB_SERIALIZER : DotNames.JSONB_DESERIALIZER, typeName)) != null) {
            return Result.of(subclass.name().toString());
        }
        return null;
    }

    @BuildStep
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    public void reflectiveValueSerializerPayload(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndex.getIndex();
        Config config = ConfigProvider.getConfig();
        this.processOutgoingForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
        this.processOutgoingChannelForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
        this.processIncomingForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
        this.processIncomingChannelForReflectiveClassPayload(index, config, (annotation, payloadType) -> this.produceReflectiveClass(reflectiveClass, (Type)payloadType));
    }

    void produceReflectiveClass(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Type type) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{type.name().toString()}).reason(this.getClass().getName()).methods().fields().build());
    }

    void processOutgoingForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.OUTGOING, true, annotation -> this.getOutgoingTypeFromMethod(annotation.target().asMethod()), annotationAcceptor);
    }

    void processOutgoingChannelForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.CHANNEL, true, annotation -> this.getOutgoingTypeFromChannelInjectionPoint(this.getInjectionPointType((AnnotationInstance)annotation)), annotationAcceptor);
    }

    void processIncomingForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.INCOMING, false, annotation -> this.getIncomingTypeFromMethod(annotation.target().asMethod()), annotationAcceptor);
    }

    void processIncomingChannelForReflectiveClassPayload(IndexView index, Config config, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        this.processAnnotationsForReflectiveClassPayload(index, config, DotNames.CHANNEL, false, annotation -> this.getIncomingTypeFromChannelInjectionPoint(this.getInjectionPointType((AnnotationInstance)annotation)), annotationAcceptor);
    }

    private void processAnnotationsForReflectiveClassPayload(IndexView index, Config config, DotName annotationType, boolean serializer, Function<AnnotationInstance, Type> typeExtractor, BiConsumer<AnnotationInstance, Type> annotationAcceptor) {
        for (AnnotationInstance annotation : index.getAnnotations(annotationType)) {
            String channelName = annotation.value().asString();
            Type type = typeExtractor.apply(annotation);
            this.extractKeyValueType(type, (Functions.TriConsumer<Type, Type, Boolean>)((Functions.TriConsumer)(key, value, isBatch) -> {
                if (key != null && this.isSerdeJson(index, config, channelName, serializer, true)) {
                    annotationAcceptor.accept(annotation, (Type)key);
                }
                if (value != null && this.isSerdeJson(index, config, channelName, serializer, false)) {
                    annotationAcceptor.accept(annotation, (Type)value);
                }
            }));
        }
    }

    private boolean isSerdeJson(IndexView index, Config config, String channelName, boolean serializer, boolean isKey) {
        String configKey = SmallRyeReactiveMessagingKafkaProcessor.getChannelPropertyKey(channelName, (isKey ? "key" : "value") + "." + (serializer ? "serializer" : "deserializer"), !serializer);
        ConfigValue configValue = config.getConfigValue(configKey);
        if (configValue.getValue() != null) {
            DotName serdeName = DotName.createSimple((String)configValue.getValue());
            return serializer ? this.isSubclassOfJsonSerializer(index, serdeName) : this.isSubclassOfJsonDeserializer(index, serdeName);
        }
        return false;
    }

    private boolean isSubclassOfJsonSerializer(IndexView index, DotName serializerName) {
        return this.isSubclassOf(index, DotNames.OBJECT_MAPPER_SERIALIZER, serializerName) || this.isSubclassOf(index, DotNames.JSONB_SERIALIZER, serializerName);
    }

    private boolean isSubclassOfJsonDeserializer(IndexView index, DotName serializerName) {
        return this.isSubclassOf(index, DotNames.OBJECT_MAPPER_DESERIALIZER, serializerName) || this.isSubclassOf(index, DotNames.JSONB_DESERIALIZER, serializerName);
    }

    private boolean isSubclassOf(IndexView index, DotName superclass, DotName expectedType) {
        if (superclass.equals((Object)expectedType)) {
            return true;
        }
        return index.getKnownDirectSubclasses(superclass).stream().anyMatch(ci -> ci.name().equals((Object)expectedType));
    }
}

