/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment.devui;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.runtime.dev.ui.Connectors;
import io.quarkus.smallrye.reactivemessaging.runtime.dev.ui.DevConsoleRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.dev.ui.ReactiveMessagingJsonRpcService;
import java.util.HashMap;
import org.jboss.jandex.AnnotationInstance;

public class ReactiveMessagingDevUIProcessor {
    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsLocalDevelopment.class})
    public void collectInjectionInfo(DevConsoleRecorder recorder, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished) {
        HashMap<String, String> emitters = new HashMap<String, String>();
        HashMap<String, String> channels = new HashMap<String, String>();
        for (InjectionPointInfo injectionPoint : beanDiscoveryFinished.getInjectionPoints()) {
            boolean isEmitter;
            AnnotationInstance channelAnnotation = injectionPoint.getRequiredQualifier(ReactiveMessagingDotNames.CHANNEL);
            if (channelAnnotation == null) {
                channelAnnotation = injectionPoint.getRequiredQualifier(ReactiveMessagingDotNames.LEGACY_CHANNEL);
            }
            boolean bl = isEmitter = injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.EMITTER) || injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.MUTINY_EMITTER) || injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.LEGACY_EMITTER);
            if (channelAnnotation == null) continue;
            if (isEmitter) {
                emitters.put(channelAnnotation.value().asString(), injectionPoint.getTargetInfo());
                continue;
            }
            channels.put(channelAnnotation.value().asString(), injectionPoint.getTargetInfo());
        }
        recorder.setInjectionInfo(emitters, channels);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.unremovableOf(Connectors.class);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    CardPageBuildItem create() {
        CardPageBuildItem card = new CardPageBuildItem();
        card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Channels")).componentLink("qwc-smallrye-reactive-messaging-channels.js").icon("font-awesome-solid:diagram-project"));
        return card;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCServiceForCache() {
        return new JsonRPCProvidersBuildItem(ReactiveMessagingJsonRpcService.class);
    }
}

