/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment.items;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.BroadcastLiteral;
import io.quarkus.smallrye.reactivemessaging.deployment.OnOverflowLiteral;
import io.quarkus.smallrye.reactivemessaging.runtime.EmitterFactoryForLiteral;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusEmitterConfiguration;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.annotations.Broadcast;

public final class InjectedEmitterBuildItem
extends MultiBuildItem {
    private final String name;
    private final String overflow;
    private final int bufferSize;
    private final boolean hasBroadcast;
    private final String emitterType;
    private final int awaitSubscribers;

    public static InjectedEmitterBuildItem of(String name, String emitterType, String overflow, int bufferSize, boolean hasBroadcast, int awaitSubscribers) {
        return new InjectedEmitterBuildItem(name, emitterType, overflow, bufferSize, hasBroadcast, awaitSubscribers);
    }

    public InjectedEmitterBuildItem(String name, String emitterType, String overflow, int bufferSize, boolean hasBroadcast, int awaitSubscribers) {
        this.name = name;
        this.overflow = overflow;
        this.emitterType = emitterType;
        this.bufferSize = bufferSize;
        this.hasBroadcast = hasBroadcast;
        this.awaitSubscribers = hasBroadcast ? awaitSubscribers : -1;
    }

    public EmitterConfiguration getEmitterConfig() {
        return new QuarkusEmitterConfiguration(this.name, EmitterFactoryForLiteral.of(this.loadEmitterClass()), OnOverflowLiteral.create(this.overflow, this.bufferSize), (Broadcast)(this.hasBroadcast ? new BroadcastLiteral(this.awaitSubscribers) : null));
    }

    private Class<?> loadEmitterClass() {
        try {
            return Class.forName(this.emitterType, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

