/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.mongodb.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.liquibase.mongodb.LiquibaseMongodbFactory;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbBuildTimeClientConfig;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbBuildTimeConfig;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbClient;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbClientConfig;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbConfig;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Supplier;
import liquibase.Liquibase;

@Recorder
public class LiquibaseMongodbRecorder {
    private final LiquibaseMongodbBuildTimeConfig buildTimeConfig;
    private final RuntimeValue<LiquibaseMongodbConfig> runtimeConfig;
    private final RuntimeValue<MongodbConfig> mongodbRuntimeConfig;

    public LiquibaseMongodbRecorder(LiquibaseMongodbBuildTimeConfig buildTimeConfig, RuntimeValue<LiquibaseMongodbConfig> runtimeConfig, RuntimeValue<MongodbConfig> mongodbRuntimeConfig) {
        this.buildTimeConfig = buildTimeConfig;
        this.runtimeConfig = runtimeConfig;
        this.mongodbRuntimeConfig = mongodbRuntimeConfig;
    }

    public Supplier<LiquibaseMongodbFactory> liquibaseSupplier(final String clientName) {
        return new Supplier<LiquibaseMongodbFactory>(){

            private <T> T getRequiredConfig(Map<String, T> map, String errorMessage) {
                T value = map.get(clientName);
                if (value == null) {
                    throw new IllegalArgumentException(errorMessage.formatted(clientName));
                }
                return value;
            }

            @Override
            public LiquibaseMongodbFactory get() {
                String clientNameSelected;
                MongoClientConfig mongoClientConfig;
                LiquibaseMongodbBuildTimeClientConfig buildTimeClientConfig = this.getRequiredConfig(LiquibaseMongodbRecorder.this.buildTimeConfig.clientConfigs(), "Liquibase Mongo config (changeLog) named '%s' not found");
                LiquibaseMongodbClientConfig liquibaseMongodbClientConfig = this.getRequiredConfig(((LiquibaseMongodbConfig)LiquibaseMongodbRecorder.this.runtimeConfig.getValue()).clientConfigs(), "Liquibase Mongo client config named '%s' not found");
                if (liquibaseMongodbClientConfig.mongoClientName().isPresent()) {
                    String forceMongoClientName = liquibaseMongodbClientConfig.mongoClientName().get();
                    mongoClientConfig = (MongoClientConfig)((MongodbConfig)LiquibaseMongodbRecorder.this.mongodbRuntimeConfig.getValue()).mongoClientConfigs().get(forceMongoClientName);
                    if (mongoClientConfig == null) {
                        throw new IllegalArgumentException("Mongo client named '%s' not found".formatted(forceMongoClientName));
                    }
                    clientNameSelected = forceMongoClientName;
                } else if (MongoClientBeanUtil.isDefault((String)clientName)) {
                    mongoClientConfig = ((MongodbConfig)LiquibaseMongodbRecorder.this.mongodbRuntimeConfig.getValue()).defaultMongoClientConfig();
                    clientNameSelected = clientName;
                } else {
                    mongoClientConfig = (MongoClientConfig)this.getRequiredConfig(((MongodbConfig)LiquibaseMongodbRecorder.this.mongodbRuntimeConfig.getValue()).mongoClientConfigs(), "Mongo client named '%s' not found");
                    clientNameSelected = clientName;
                }
                return new LiquibaseMongodbFactory(liquibaseMongodbClientConfig, buildTimeClientConfig, mongoClientConfig, clientNameSelected);
            }
        };
    }

    private Annotation getLiquibaseMongodbQualifier(String clientName) {
        if (MongoClientBeanUtil.isDefault((String)clientName)) {
            return Default.Literal.INSTANCE;
        }
        return LiquibaseMongodbClient.LiquibaseMongodbClientLiteral.of(clientName);
    }

    public void doStartActions(String clientName) {
        if (!((LiquibaseMongodbConfig)this.runtimeConfig.getValue()).enabled()) {
            return;
        }
        try {
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseMongodbFactory.class, new Annotation[]{this.getLiquibaseMongodbQualifier(clientName)});
            if (liquibaseFactoryInstance.isUnsatisfied()) {
                return;
            }
            for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
                try {
                    LiquibaseMongodbFactory liquibaseFactory = (LiquibaseMongodbFactory)liquibaseFactoryHandle.get();
                    if (!liquibaseFactory.getConfiguration().cleanAtStart() && !liquibaseFactory.getConfiguration().migrateAtStart()) {
                        return;
                    }
                    Liquibase liquibase = liquibaseFactory.createLiquibase();
                    try {
                        if (liquibaseFactory.getConfiguration().cleanAtStart()) {
                            liquibase.dropAll();
                        }
                        if (!liquibaseFactory.getConfiguration().migrateAtStart()) continue;
                        if (liquibaseFactory.getConfiguration().validateOnMigrate()) {
                            liquibase.validate();
                        }
                        liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                    }
                    finally {
                        if (liquibase == null) continue;
                        liquibase.close();
                    }
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }
}

