/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.mongodb.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.liquibase.mongodb.LiquibaseMongodbFactory;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbBuildTimeConfig;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbConfig;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import liquibase.Liquibase;

@Recorder
public class LiquibaseMongodbRecorder {
    private final RuntimeValue<LiquibaseMongodbConfig> config;

    public LiquibaseMongodbRecorder(RuntimeValue<LiquibaseMongodbConfig> config) {
        this.config = config;
    }

    public Supplier<LiquibaseMongodbFactory> liquibaseSupplier(final LiquibaseMongodbConfig config, final LiquibaseMongodbBuildTimeConfig buildTimeConfig, final MongodbConfig mongodbConfig) {
        return new Supplier<LiquibaseMongodbFactory>(){

            @Override
            public LiquibaseMongodbFactory get() {
                return new LiquibaseMongodbFactory(config, buildTimeConfig, mongodbConfig.defaultMongoClientConfig());
            }
        };
    }

    public void doStartActions() {
        if (!((LiquibaseMongodbConfig)this.config.getValue()).enabled()) {
            return;
        }
        try {
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseMongodbFactory.class, new Annotation[]{Any.Literal.INSTANCE});
            if (liquibaseFactoryInstance.isUnsatisfied()) {
                return;
            }
            for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
                try {
                    LiquibaseMongodbFactory liquibaseFactory = (LiquibaseMongodbFactory)liquibaseFactoryHandle.get();
                    if (!liquibaseFactory.getConfiguration().cleanAtStart() && !liquibaseFactory.getConfiguration().migrateAtStart()) {
                        return;
                    }
                    Liquibase liquibase = liquibaseFactory.createLiquibase();
                    try {
                        if (liquibaseFactory.getConfiguration().cleanAtStart()) {
                            liquibase.dropAll();
                        }
                        if (!liquibaseFactory.getConfiguration().migrateAtStart()) continue;
                        if (liquibaseFactory.getConfiguration().validateOnMigrate()) {
                            liquibase.validate();
                        }
                        liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                    }
                    finally {
                        if (liquibase == null) continue;
                        liquibase.close();
                    }
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }
}

