/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.mongodb.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.InitTaskBuildItem;
import io.quarkus.deployment.builditem.InitTaskCompletedBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.liquibase.mongodb.LiquibaseMongodbFactory;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbBuildTimeConfig;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbRecorder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.paths.PathFilter;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import liquibase.GlobalConfiguration;
import liquibase.change.AbstractSQLChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.FastCheckService;
import liquibase.command.CommandFactory;
import liquibase.command.CommandStep;
import liquibase.configuration.ConfiguredValueModifierFactory;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.LiquibaseTableNamesFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.LiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.change.CreateCollectionChange;
import liquibase.ext.mongodb.change.CreateIndexChange;
import liquibase.ext.mongodb.change.DropCollectionChange;
import liquibase.ext.mongodb.change.DropIndexChange;
import liquibase.ext.mongodb.change.InsertManyChange;
import liquibase.ext.mongodb.change.InsertOneChange;
import liquibase.ext.mongodb.database.MongoClientDriver;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserConfiguration;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.plugin.AbstractPluginFactory;
import liquibase.precondition.Precondition;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.visitor.AppendSqlVisitor;
import liquibase.sql.visitor.PrependSqlVisitor;
import liquibase.sql.visitor.RegExpReplaceSqlVisitor;
import liquibase.sql.visitor.ReplaceSqlVisitor;
import liquibase.sqlgenerator.core.LockDatabaseChangeLogGenerator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class LiquibaseMongodbProcessor {
    private static final Logger LOGGER = Logger.getLogger(LiquibaseMongodbProcessor.class);
    private static final ArtifactCoords LIQUIBASE_ARTIFACT = Dependency.of((String)"org.liquibase", (String)"liquibase-core", (String)"*");
    private static final ArtifactCoords LIQUIBASE_MONGODB_ARTIFACT = Dependency.of((String)"org.liquibase.ext", (String)"liquibase-mongodb", (String)"*");
    private static final PathFilter LIQUIBASE_RESOURCE_FILTER = PathFilter.forIncludes(List.of("*.properties", "www.liquibase.org/xml/ns/dbchangelog/*.xsd"));
    private static final PathFilter LIQUIBASE_MONGODB_RESOURCE_FILTER = PathFilter.forIncludes(List.of("www.liquibase.org/xml/ns/mongodb/*.xsd", "liquibase.parser.core.xml/*.xsd"));
    private static final DotName DATABASE_CHANGE_PROPERTY = DotName.createSimple((String)DatabaseChangeProperty.class.getName());

    LiquibaseMongodbProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.LIQUIBASE_MONGODB);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    List<IndexDependencyBuildItem> indexLiquibase() {
        return List.of(new IndexDependencyBuildItem(LIQUIBASE_ARTIFACT.getGroupId(), LIQUIBASE_ARTIFACT.getArtifactId()), new IndexDependencyBuildItem(LIQUIBASE_MONGODB_ARTIFACT.getGroupId(), LIQUIBASE_MONGODB_ARTIFACT.getArtifactId()));
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void nativeImageConfiguration(LiquibaseMongodbBuildTimeConfig liquibaseBuildConfig, CombinedIndexBuildItem combinedIndex, CurateOutcomeBuildItem curateOutcome, BuildProducer<ReflectiveClassBuildItem> reflective, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ServiceProviderBuildItem> services, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitialized, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(CompareControl.class.getName()));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(LockDatabaseChangeLogGenerator.class.getName()));
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{AbstractSQLChange.class.getName(), AbstractMongoChange.class.getName(), CreateCollectionChange.class.getName(), CreateIndexChange.class.getName(), DropCollectionChange.class.getName(), DropIndexChange.class.getName(), InsertManyChange.class.getName(), InsertOneChange.class.getName(), JdbcConnection.class.getName()}).methods().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])combinedIndex.getIndex().getAllKnownSubclasses(AbstractPluginFactory.class).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new))).reason(this.getClass().getName()).constructors().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{CommandFactory.class.getName(), LiquibaseTableNamesFactory.class.getName(), ConfiguredValueModifierFactory.class.getName(), FastCheckService.class.getName(), liquibase.configuration.GlobalConfiguration.class.getName()}).constructors().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{LiquibaseConfiguration.class.getName(), ChangeLogParserConfiguration.class.getName(), GlobalConfiguration.class.getName(), ExecutorService.class.getName(), ChangeFactory.class.getName(), ColumnConfig.class.getName(), AddColumnConfig.class.getName(), LoadDataColumnConfig.class.getName(), PrependSqlVisitor.class.getName(), ReplaceSqlVisitor.class.getName(), AppendSqlVisitor.class.getName(), RegExpReplaceSqlVisitor.class.getName(), MongoClientDriver.class.getName()}).constructors().methods().fields().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ConstraintsConfig.class.getName()}).fields().build());
        HashSet<String> classesMarkedWithDatabaseChangeProperty = new HashSet<String>();
        for (AnnotationInstance databaseChangePropertyInstance : combinedIndex.getIndex().getAnnotations(DATABASE_CHANGE_PROPERTY)) {
            AnnotationTarget annotationTarget = databaseChangePropertyInstance.target();
            if (annotationTarget.kind() != AnnotationTarget.Kind.METHOD) continue;
            classesMarkedWithDatabaseChangeProperty.add(annotationTarget.asMethod().declaringClass().name().toString());
        }
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classesMarkedWithDatabaseChangeProperty.toArray(new String[0])).reason(this.getClass().getName()).constructors().methods().fields().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(this.getChangeLogs(liquibaseBuildConfig).toArray(new String[0])));
        this.addService(services, reflective, Precondition.class.getName(), true, new String[0]);
        this.addService(services, reflective, CommandStep.class.getName(), false, "liquibase.command.core.StartH2CommandStep");
        Collection dependencies = curateOutcome.getApplicationModel().getRuntimeDependencies();
        resource.produce((BuildItem)NativeImageResourceBuildItem.ofDependencyResources((Collection)dependencies, (ArtifactCoords)LIQUIBASE_ARTIFACT, (PathFilter)LIQUIBASE_RESOURCE_FILTER));
        resource.produce((BuildItem)NativeImageResourceBuildItem.ofDependencyResources((Collection)dependencies, (ArtifactCoords)LIQUIBASE_MONGODB_ARTIFACT, (PathFilter)LIQUIBASE_MONGODB_RESOURCE_FILTER));
        services.produce(ServiceProviderBuildItem.allProvidersOfDependencies((Collection)dependencies, List.of(LIQUIBASE_ARTIFACT, LIQUIBASE_MONGODB_ARTIFACT)));
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem("liquibase/i18n/liquibase-core"));
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem("liquibase/i18n/liquibase-mongo"));
    }

    private void addService(BuildProducer<ServiceProviderBuildItem> services, BuildProducer<ReflectiveClassBuildItem> reflective, String serviceClassName, boolean shouldRegisterFieldForReflection, String ... excludedImpls) {
        try {
            String service = "META-INF/services/" + serviceClassName;
            HashSet implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service);
            if (excludedImpls.length > 0) {
                implementations = new HashSet(implementations);
                Arrays.asList(excludedImpls).forEach(implementations::remove);
            }
            services.produce((BuildItem)new ServiceProviderBuildItem(serviceClassName, implementations.toArray(new String[0])));
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])implementations.toArray(new String[0])).reason(this.getClass().getName()).constructors().methods().fields(shouldRegisterFieldForReflection).build());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBeans(LiquibaseMongodbRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(LiquibaseMongodbFactory.class).scope(ApplicationScoped.class)).setRuntimeInit().unremovable()).supplier(recorder.liquibaseSupplier());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=BeanContainerBuildItem.class)
    ServiceStartBuildItem startLiquibase(LiquibaseMongodbRecorder recorder, BuildProducer<InitTaskCompletedBuildItem> initializationCompleteBuildItem) {
        recorder.doStartActions();
        initializationCompleteBuildItem.produce((BuildItem)new InitTaskCompletedBuildItem("liquibase-mongodb"));
        return new ServiceStartBuildItem("liquibase-mongodb");
    }

    @BuildStep
    public InitTaskBuildItem configureInitTask(ApplicationInfoBuildItem app) {
        return InitTaskBuildItem.create().withName(app.getName() + "-liquibase-mongodb-init").withTaskEnvVars(Map.of("QUARKUS_INIT_AND_EXIT", "true", "QUARKUS_LIQUIBASE_MONGODB_ENABLED", "true")).withAppEnvVars(Map.of("QUARKUS_LIQUIBASE_MONGODB_ENABLED", "false")).withSharedEnvironment(true).withSharedFilesystem(true);
    }

    private List<String> getChangeLogs(LiquibaseMongodbBuildTimeConfig liquibaseBuildConfig) {
        ArrayList<String> arrayList;
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        ChangeLogParserFactory changeLogParserFactory = ChangeLogParserFactory.getInstance();
        ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader());
        try {
            LinkedHashSet<String> resources = new LinkedHashSet<String>(this.findAllChangeLogFiles(liquibaseBuildConfig.changeLog(), changeLogParserFactory, classLoaderResourceAccessor, changeLogParameters));
            LOGGER.debugf("Liquibase changeLogs: %s", resources);
            arrayList = new ArrayList<String>(resources);
        }
        catch (Throwable throwable) {
            try {
                try {
                    classLoaderResourceAccessor.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Error while loading the liquibase changelogs: %s".formatted(ex.getMessage()), ex);
            }
        }
        classLoaderResourceAccessor.close();
        return arrayList;
    }

    private Set<String> findAllChangeLogFiles(String file, ChangeLogParserFactory changeLogParserFactory, ClassLoaderResourceAccessor classLoaderResourceAccessor, ChangeLogParameters changeLogParameters) {
        try {
            ChangeLogParser parser = changeLogParserFactory.getParser(file, (ResourceAccessor)classLoaderResourceAccessor);
            DatabaseChangeLog changelog = parser.parse(file, changeLogParameters, (ResourceAccessor)classLoaderResourceAccessor);
            if (changelog != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (ChangeSet changeSet : changelog.getChangeSets()) {
                    result.add(changeSet.getFilePath());
                    changeSet.getChanges().stream().map(change -> this.extractChangeFile((Change)change, changeSet.getFilePath())).forEach(changeFile -> changeFile.ifPresent(result::add));
                    for (DatabaseChangeLog parent = changeSet.getChangeLog(); parent != null; parent = parent.getParentChangeLog()) {
                        result.add(parent.getFilePath());
                    }
                }
                result.add(changelog.getFilePath());
                return result;
            }
        }
        catch (LiquibaseException ex) {
            throw new IllegalStateException(ex);
        }
        return Collections.emptySet();
    }

    private Optional<String> extractChangeFile(Change change, String changeSetFilePath) {
        String path = null;
        Boolean relative = null;
        if (change instanceof LoadDataChange) {
            LoadDataChange loadDataChange = (LoadDataChange)change;
            path = loadDataChange.getFile();
            relative = loadDataChange.isRelativeToChangelogFile();
        } else if (change instanceof SQLFileChange) {
            SQLFileChange sqlFileChange = (SQLFileChange)change;
            path = sqlFileChange.getPath();
            relative = sqlFileChange.isRelativeToChangelogFile();
        } else if (change instanceof CreateProcedureChange) {
            CreateProcedureChange createProcedureChange = (CreateProcedureChange)change;
            path = createProcedureChange.getPath();
            relative = createProcedureChange.isRelativeToChangelogFile();
        } else if (change instanceof CreateViewChange) {
            CreateViewChange createViewChange = (CreateViewChange)change;
            path = createViewChange.getPath();
            relative = createViewChange.getRelativeToChangelogFile();
        }
        if (path == null) {
            return Optional.empty();
        }
        if (relative == null || !relative.booleanValue() || changeSetFilePath == null) {
            return Optional.of(path);
        }
        return Optional.of(Paths.get(changeSetFilePath, new String[0]).resolveSibling(path).toString().replace('\\', '/'));
    }
}

