/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.quarkus.kubernetes.spi.RoleRef;
import io.quarkus.kubernetes.spi.Subject;
import java.util.HashMap;
import java.util.Map;

public class AddRoleBindingResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String deploymentName;
    private final String name;
    private final String namespace;
    private final Map<String, String> labels;
    private final RoleRef roleRef;
    private final Subject[] subjects;

    public AddRoleBindingResourceDecorator(String deploymentName, String name, String namespace, Map<String, String> labels, RoleRef roleRef, Subject ... subjects) {
        this.deploymentName = deploymentName;
        this.name = name;
        this.labels = labels;
        this.roleRef = roleRef;
        this.subjects = subjects;
        this.namespace = namespace;
    }

    public void visit(KubernetesListBuilder list) {
        if (this.contains(list, "rbac.authorization.k8s.io/v1", "RoleBinding", this.name)) {
            return;
        }
        HashMap<String, String> roleBindingLabels = new HashMap<String, String>(this.labels);
        this.getDeploymentMetadata(list, this.deploymentName).map(ObjectMeta::getLabels).ifPresent(roleBindingLabels::putAll);
        RoleBindingFluent.MetadataNested metadataBuilder = (RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(this.name)).withLabels(roleBindingLabels);
        if (this.namespace != null) {
            metadataBuilder.withNamespace(this.namespace);
        }
        RoleBindingBuilder builder = (RoleBindingBuilder)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingBuilder)metadataBuilder.endMetadata()).withNewRoleRef().withKind(this.roleRef.isClusterWide() ? "ClusterRole" : "Role")).withName(this.roleRef.getName())).withApiGroup("rbac.authorization.k8s.io")).endRoleRef();
        for (Subject subject : this.subjects) {
            ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withApiGroup(subject.getApiGroup())).withKind(subject.getKind())).withName(Strings.defaultIfEmpty((String)subject.getName(), (String)this.deploymentName))).withNamespace(subject.getNamespace())).endSubject();
        }
        list.addToItems(new HasMetadata[]{builder.build()});
    }
}

