/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.Sysctl;
import io.fabric8.kubernetes.api.model.SysctlBuilder;
import io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions;
import io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder;
import io.quarkus.kubernetes.deployment.SecurityContextConfig;
import java.util.Optional;

public class ApplySecuritySettingsDecorator
extends NamedResourceDecorator<PodSpecFluent> {
    private final SecurityContextConfig securityContext;

    public ApplySecuritySettingsDecorator(String resourceName, SecurityContextConfig securityContext) {
        super(resourceName);
        this.securityContext = securityContext;
    }

    public void andThenVisit(PodSpecFluent podSpec, ObjectMeta resourceMeta) {
        PodSecurityContextBuilder securityContextBuilder = new PodSecurityContextBuilder();
        this.securityContext.runAsUser().ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).withRunAsUser(arg_0));
        this.securityContext.runAsGroup().ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).withRunAsGroup(arg_0));
        this.securityContext.runAsNonRoot().ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).withRunAsNonRoot(arg_0));
        this.securityContext.supplementalGroups().ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).addAllToSupplementalGroups(arg_0));
        this.securityContext.fsGroup().ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).withFsGroup(arg_0));
        this.securityContext.sysctls().entrySet().stream().map(entry -> ((SysctlBuilder)((SysctlBuilder)new SysctlBuilder().withName((String)entry.getKey())).withValue((String)entry.getValue())).build()).forEach(xva$0 -> {
            PodSecurityContextBuilder cfr_ignored_0 = (PodSecurityContextBuilder)securityContextBuilder.addToSysctls(new Sysctl[]{xva$0});
        });
        this.securityContext.fsGroupChangePolicy().map(e -> e.name()).ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).withFsGroupChangePolicy(arg_0));
        this.buildSeLinuxOptions().ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).withSeLinuxOptions(arg_0));
        this.buildWindowsOptions().ifPresent(arg_0 -> ((PodSecurityContextBuilder)securityContextBuilder).withWindowsOptions(arg_0));
        podSpec.withSecurityContext(securityContextBuilder.build());
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }

    private Optional<WindowsSecurityContextOptions> buildWindowsOptions() {
        WindowsSecurityContextOptions item = null;
        if (this.securityContext.windowsOptions().isAnyPropertySet()) {
            WindowsSecurityContextOptionsBuilder builder = new WindowsSecurityContextOptionsBuilder();
            this.securityContext.windowsOptions().gmsaCredentialSpec().ifPresent(arg_0 -> ((WindowsSecurityContextOptionsBuilder)builder).withGmsaCredentialSpec(arg_0));
            this.securityContext.windowsOptions().gmsaCredentialSpecName().ifPresent(arg_0 -> ((WindowsSecurityContextOptionsBuilder)builder).withGmsaCredentialSpecName(arg_0));
            this.securityContext.windowsOptions().hostProcess().ifPresent(arg_0 -> ((WindowsSecurityContextOptionsBuilder)builder).withHostProcess(arg_0));
            this.securityContext.windowsOptions().runAsUserName().ifPresent(arg_0 -> ((WindowsSecurityContextOptionsBuilder)builder).withRunAsUserName(arg_0));
            item = builder.build();
        }
        return Optional.ofNullable(item);
    }

    private Optional<SELinuxOptions> buildSeLinuxOptions() {
        SELinuxOptions item = null;
        if (this.securityContext.seLinuxOptions().isAnyPropertySet()) {
            SELinuxOptionsBuilder builder = new SELinuxOptionsBuilder();
            this.securityContext.seLinuxOptions().user().ifPresent(arg_0 -> ((SELinuxOptionsBuilder)builder).withUser(arg_0));
            this.securityContext.seLinuxOptions().role().ifPresent(arg_0 -> ((SELinuxOptionsBuilder)builder).withRole(arg_0));
            this.securityContext.seLinuxOptions().level().ifPresent(arg_0 -> ((SELinuxOptionsBuilder)builder).withLevel(arg_0));
            this.securityContext.seLinuxOptions().type().ifPresent(arg_0 -> ((SELinuxOptionsBuilder)builder).withType(arg_0));
            item = builder.build();
        }
        return Optional.ofNullable(item);
    }
}

