/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.s2i.decorator.AddBuildConfigResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.quarkus.container.spi.ImageReference;
import java.util.Optional;

public class ApplyBuilderImageDecorator
extends NamedResourceDecorator<SourceBuildStrategyFluent<?>> {
    private final String image;

    public ApplyBuilderImageDecorator(String image) {
        this(ANY, image);
    }

    public ApplyBuilderImageDecorator(String name, String image) {
        super(name);
        this.image = image;
    }

    public void andThenVisit(SourceBuildStrategyFluent<?> strategy, ObjectMeta meta) {
        ImageReference imageRef = ImageReference.parse((String)this.image);
        String builderRepository = imageRef.getRepository();
        String builderTag = imageRef.getTag();
        String builderName = !builderRepository.contains("/") ? builderRepository : builderRepository.substring(builderRepository.lastIndexOf("/") + 1);
        Optional<String> builderGroup = Optional.of(builderRepository).filter(s -> s.contains("/")).map(s -> s.substring(0, s.indexOf("/")));
        boolean usesInternalRegistry = imageRef.getRegistry().filter(registry -> registry.contains("openshift-image-registry")).isPresent();
        ((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)strategy.withNewFrom().withKind("ImageStreamTag")).withName(builderName + ":" + builderTag)).withNamespace((String)builderGroup.filter(g -> usesInternalRegistry).orElse(null))).endFrom();
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddBuildConfigResourceDecorator.class};
    }
}

