/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.KubernetesConfigFluent;
import io.dekorate.kubernetes.config.Port;
import java.util.Objects;

public class AddPortToKubernetesConfig
extends Configurator<KubernetesConfigFluent<?>> {
    private final Port port;

    public AddPortToKubernetesConfig(Port port) {
        this.port = port;
    }

    public void visit(KubernetesConfigFluent<?> config) {
        if (!this.hasPort(config)) {
            config.addToPorts(new Port[]{this.port});
        }
    }

    private boolean hasPort(KubernetesConfigFluent<?> config) {
        for (Port p : config.buildPorts()) {
            if (!Objects.equals(p.getContainerPort(), this.port.getContainerPort())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddPortToKubernetesConfig addPort = (AddPortToKubernetesConfig)((Object)o);
        return Objects.equals(this.port, addPort.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }
}

