/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.kubernetes.decorator.AbstractAddProbeDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Metadata;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApplyHttpGetActionPortDecorator
extends Decorator<HTTPGetActionFluent<?>>
implements WithConfigReferences {
    private static final String PATH_ALL_EXPRESSION = "*.spec.containers.";
    private static final String PATH_DEPLOYMENT_CONTAINER_EXPRESSION = "(metadata.name == %s).spec.template.spec.containers.(name == %s).";
    private static final String PATH_DEPLOYMENT_EXPRESSION = "(metadata.name == %s).spec.template.spec.containers.";
    private static final String PATH_CONTAINER_EXPRESSION = "*.spec.containers.(name == %s).";
    private final String deployment;
    private final String container;
    private final String portName;
    private final Integer port;
    private final String scheme;
    private final String probeKind;

    public ApplyHttpGetActionPortDecorator(Integer port) {
        this(ANY, ANY, port, ANY);
    }

    public ApplyHttpGetActionPortDecorator(Integer port, String probeKind) {
        this(ANY, ANY, port, probeKind);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, Integer port) {
        this(deployment, ANY, port, ANY);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, Integer port, String probeKind) {
        this(deployment, ANY, port, probeKind);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, String container, Integer port) {
        this(deployment, container, port, ANY);
    }

    public ApplyHttpGetActionPortDecorator(String deployment, String container, Integer port, String probeKind) {
        this(deployment, container, null, port, probeKind, port != null && (port == 443 || port == 8443) ? "HTTPS" : "HTTP");
    }

    public ApplyHttpGetActionPortDecorator(String deployment, String container, String portName, Integer port, String probeKind, String scheme) {
        this.deployment = deployment;
        this.container = container;
        this.portName = portName;
        this.port = port;
        this.probeKind = probeKind;
        this.scheme = scheme;
    }

    public void visit(List<Map.Entry<String, Object>> path, HTTPGetActionFluent<?> action) {
        boolean inMatchingResource;
        boolean inMatchingContainer;
        boolean inMatchingProbe;
        boolean bl = inMatchingProbe = this.probeKind == ANY || path.stream().map(e -> (String)e.getKey()).anyMatch(i -> i.equals(this.probeKind));
        if (!inMatchingProbe) {
            return;
        }
        boolean bl2 = inMatchingContainer = this.container == ANY || path.stream().map(e -> e.getValue()).filter(v -> v instanceof ContainerBuilder).map(v -> (ContainerBuilder)v).anyMatch(c -> c.getName() != null && c.getName().equals(this.container));
        if (!inMatchingContainer) {
            return;
        }
        boolean bl3 = inMatchingResource = this.deployment == ANY || path.stream().map(e -> e.getValue()).filter(v -> v instanceof Builder).map(v -> (Builder)v).map(b -> Metadata.getMetadata((Builder)b)).filter(m -> m.isPresent()).map(Optional::get).anyMatch(m -> m.getName() != null && m.getName().equals(this.deployment));
        if (!inMatchingResource) {
            return;
        }
        this.visit(action);
    }

    public void visit(HTTPGetActionFluent<?> action) {
        if (this.port == null) {
            action.withNewPort((Object)null);
        } else {
            action.withNewPort((Object)this.port);
        }
        if (this.scheme == null) {
            action.withScheme((String)null);
        } else {
            action.withScheme(this.scheme);
        }
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddSidecarDecorator.class, AbstractAddProbeDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        if (this.portName != null && this.probeKind != null) {
            return List.of(this.buildConfigReference(ConfigReference.joinProperties((String[])new String[]{"ports." + this.portName}), "httpGet.port", this.port, "The http port to use for the probe."));
        }
        return Collections.emptyList();
    }

    private ConfigReference buildConfigReference(String property, String probeField, Object value, String description) {
        String expression = PATH_ALL_EXPRESSION;
        if (Strings.isNotNullOrEmpty((String)this.deployment) && Strings.isNotNullOrEmpty((String)this.container)) {
            expression = String.format(PATH_DEPLOYMENT_CONTAINER_EXPRESSION, this.deployment, this.container);
        } else if (Strings.isNotNullOrEmpty((String)this.deployment)) {
            expression = String.format(PATH_DEPLOYMENT_EXPRESSION, this.deployment);
        } else if (Strings.isNotNullOrEmpty((String)this.container)) {
            expression = String.format(PATH_CONTAINER_EXPRESSION, this.container);
        }
        String yamlPath = expression + this.probeKind + "." + probeField;
        return new ConfigReference.Builder(property, yamlPath).withDescription(description).withValue(value).build();
    }
}

