/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import java.util.Optional;

public interface EnvVarPrefixConfig {
    public Optional<String> forSecret();

    public Optional<String> forConfigmap();

    default public boolean anyPresent() {
        return this.forSecret().isPresent() || this.forConfigmap().isPresent();
    }

    default public boolean hasConfigmap() {
        return this.forConfigmap().isPresent();
    }

    default public boolean hasSecret() {
        return this.forSecret().isPresent();
    }

    default public boolean hasPrefixForSecret(String secret) {
        return this.forSecret().map(s -> s.equals(secret)).orElse(false);
    }

    default public boolean hasPrefixForConfigmap(String configmap) {
        return this.forConfigmap().map(c -> c.equals(configmap)).orElse(false);
    }
}

