/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.config.runtime;

import io.quarkus.kubernetes.config.runtime.KubernetesConfigBuildTimeConfig;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigSourceConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.jboss.logging.Logger;

@Recorder
public class KubernetesConfigRecorder {
    private static final Logger log = Logger.getLogger(KubernetesConfigRecorder.class);
    private final KubernetesConfigBuildTimeConfig buildTimeConfig;
    private final RuntimeValue<KubernetesConfigSourceConfig> runtimeConfig;

    public KubernetesConfigRecorder(KubernetesConfigBuildTimeConfig buildTimeConfig, RuntimeValue<KubernetesConfigSourceConfig> runtimeConfig) {
        this.buildTimeConfig = buildTimeConfig;
        this.runtimeConfig = runtimeConfig;
    }

    public void warnAboutSecrets() {
        if (((KubernetesConfigSourceConfig)this.runtimeConfig.getValue()).secrets().isPresent() && !((KubernetesConfigSourceConfig)this.runtimeConfig.getValue()).secrets().get().isEmpty() && !this.buildTimeConfig.secretsEnabled()) {
            log.warn((Object)("Configuration is read from Secrets " + String.valueOf(((KubernetesConfigSourceConfig)this.runtimeConfig.getValue()).secrets().get()) + ", but quarkus.kubernetes-config.secrets.enabled is false. Check if your application's service account has enough permissions to read secrets."));
        }
    }
}

