/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.config.runtime;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.quarkus.kubernetes.client.runtime.internal.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.client.runtime.internal.KubernetesClientUtils;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigSourceFactory;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class KubernetesConfigSourceFactoryBuilder
implements ConfigBuilder {
    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        return builder.withSources(new ConfigSourceFactory[]{new KubernetesConfigFactory()});
    }

    static class KubernetesConfigFactory
    implements ConfigSourceFactory.ConfigurableConfigSourceFactory<KubernetesClientBuildConfig> {
        KubernetesConfigFactory() {
        }

        public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context, KubernetesClientBuildConfig config) {
            boolean inAppCDsGeneration = Boolean.parseBoolean(System.getProperty("quarkus.appcds.generate", "false"));
            if (inAppCDsGeneration) {
                return Collections.emptyList();
            }
            KubernetesClient client = KubernetesClientUtils.createClient((KubernetesClientBuildConfig)config);
            return new KubernetesConfigSourceFactory(client).getConfigSources(context);
        }
    }
}

