/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime.internal;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.quarkus.kubernetes.client.runtime.internal.KubernetesClientBuildConfig;
import java.time.Duration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class KubernetesClientUtils {
    private static final String PREFIX = "quarkus.kubernetes-client.";

    private KubernetesClientUtils() {
    }

    public static io.fabric8.kubernetes.client.Config createConfig(KubernetesClientBuildConfig buildConfig) {
        boolean globalTrustAll = ConfigProvider.getConfig().getOptionalValue("quarkus.tls.trust-all", Boolean.class).orElse(false);
        io.fabric8.kubernetes.client.Config base = io.fabric8.kubernetes.client.Config.autoConfigure(null);
        boolean trustAll = buildConfig.trustCerts().isPresent() ? buildConfig.trustCerts().get() : globalTrustAll;
        ConfigBuilder configBuilder = (ConfigBuilder)new ConfigBuilder(base).withTrustCerts(trustAll);
        buildConfig.watchReconnectInterval().ifPresent(d -> configBuilder.withWatchReconnectInterval(KubernetesClientUtils.millisAsInt(d)));
        buildConfig.watchReconnectLimit().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withWatchReconnectLimit(arg_0));
        buildConfig.connectionTimeout().ifPresent(d -> configBuilder.withConnectionTimeout(KubernetesClientUtils.millisAsInt(d)));
        buildConfig.requestTimeout().ifPresent(d -> configBuilder.withRequestTimeout(KubernetesClientUtils.millisAsInt(d)));
        buildConfig.apiServerUrl().or(buildConfig::masterUrl).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withMasterUrl(arg_0));
        buildConfig.namespace().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withNamespace(arg_0));
        buildConfig.username().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withUsername(arg_0));
        buildConfig.password().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withPassword(arg_0));
        buildConfig.token().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withOauthToken(arg_0));
        buildConfig.caCertFile().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withCaCertFile(arg_0));
        buildConfig.caCertData().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withCaCertData(arg_0));
        buildConfig.clientCertFile().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientCertFile(arg_0));
        buildConfig.clientCertData().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientCertData(arg_0));
        buildConfig.clientKeyFile().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyFile(arg_0));
        buildConfig.clientKeyData().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyData(arg_0));
        buildConfig.clientKeyAlgo().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyAlgo(arg_0));
        buildConfig.clientKeyPassphrase().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyPassphrase(arg_0));
        buildConfig.httpProxy().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withHttpProxy(arg_0));
        buildConfig.httpsProxy().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withHttpsProxy(arg_0));
        buildConfig.proxyUsername().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withProxyUsername(arg_0));
        buildConfig.proxyPassword().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withProxyPassword(arg_0));
        buildConfig.noProxy().ifPresent(list -> list.toArray(new String[0]));
        buildConfig.requestRetryBackoffInterval().ifPresent(d -> configBuilder.withRequestRetryBackoffInterval(KubernetesClientUtils.millisAsInt(d)));
        buildConfig.requestRetryBackoffLimit().ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withRequestRetryBackoffLimit(arg_0));
        return configBuilder.build();
    }

    private static int millisAsInt(Duration duration) {
        return (int)duration.toMillis();
    }

    public static KubernetesClient createClient(KubernetesClientBuildConfig buildConfig) {
        return new KubernetesClientBuilder().withConfig(KubernetesClientUtils.createConfig(buildConfig)).build();
    }

    public static KubernetesClient createClient() {
        Config config = ConfigProvider.getConfig();
        io.fabric8.kubernetes.client.Config base = io.fabric8.kubernetes.client.Config.autoConfigure(null);
        ConfigBuilder configBuilder = new ConfigBuilder(base);
        KubernetesClientUtils.optional(config, "trust-certs", Boolean.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withTrustCerts(arg_0));
        KubernetesClientUtils.optional(config, "watch-reconnect-limit", Integer.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withWatchReconnectLimit(arg_0));
        KubernetesClientUtils.optional(config, "watch-reconnect-interval", Duration.class).map(KubernetesClientUtils::millisAsInt).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withWatchReconnectInterval(arg_0));
        KubernetesClientUtils.optional(config, "connection-timeout", Duration.class).map(KubernetesClientUtils::millisAsInt).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withConnectionTimeout(arg_0));
        KubernetesClientUtils.optional(config, "request-timeout", Duration.class).map(KubernetesClientUtils::millisAsInt).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withRequestTimeout(arg_0));
        KubernetesClientUtils.optional(config, "api-server-url", String.class).or(() -> KubernetesClientUtils.optional(config, "master-url", String.class)).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withMasterUrl(arg_0));
        KubernetesClientUtils.optional(config, "namespace", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withNamespace(arg_0));
        KubernetesClientUtils.optional(config, "username", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withUsername(arg_0));
        KubernetesClientUtils.optional(config, "password", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withPassword(arg_0));
        KubernetesClientUtils.optional(config, "ca-cert-file", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withCaCertFile(arg_0));
        KubernetesClientUtils.optional(config, "ca-cert-data", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withCaCertData(arg_0));
        KubernetesClientUtils.optional(config, "client-cert-file", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientCertFile(arg_0));
        KubernetesClientUtils.optional(config, "client-cert-data", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientCertData(arg_0));
        KubernetesClientUtils.optional(config, "client-key-file", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyFile(arg_0));
        KubernetesClientUtils.optional(config, "client-key-data", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyData(arg_0));
        KubernetesClientUtils.optional(config, "client-key-passphrase", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyPassphrase(arg_0));
        KubernetesClientUtils.optional(config, "client-key-algo", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withClientKeyAlgo(arg_0));
        KubernetesClientUtils.optional(config, "http-proxy", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withHttpProxy(arg_0));
        KubernetesClientUtils.optional(config, "https-proxy", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withHttpsProxy(arg_0));
        KubernetesClientUtils.optional(config, "proxy-username", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withProxyUsername(arg_0));
        KubernetesClientUtils.optional(config, "proxy-password", String.class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withProxyPassword(arg_0));
        KubernetesClientUtils.optional(config, "no-proxy", String[].class).ifPresent(arg_0 -> ((ConfigBuilder)configBuilder).withNoProxy(arg_0));
        return new KubernetesClientBuilder().withConfig(configBuilder.build()).build();
    }

    private static <T> Optional<T> optional(Config config, String key, Class<T> valueType) {
        return config.getOptionalValue(PREFIX + key, valueType);
    }
}

