/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kotlin.deployment;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public class IsDataClassWithDefaultValuesPredicate
implements Predicate<ClassInfo> {
    @Override
    public boolean test(ClassInfo classInfo) {
        int ctorCount = 0;
        boolean hasCopyMethod = false;
        boolean hasStaticCopyMethod = false;
        boolean hasComponent1Method = false;
        List methods = classInfo.methods();
        for (MethodInfo method : methods) {
            String methodName = method.name();
            if ("<init>".equals(methodName)) {
                ++ctorCount;
                continue;
            }
            if ("component1".equals(methodName) && Modifier.isFinal(method.flags())) {
                hasComponent1Method = true;
                continue;
            }
            if ("copy".equals(methodName) && Modifier.isFinal(method.flags())) {
                hasCopyMethod = true;
                continue;
            }
            if (!"copy$default".equals(methodName) || !Modifier.isStatic(method.flags())) continue;
            hasStaticCopyMethod = true;
        }
        return ctorCount > 1 && hasComponent1Method && hasCopyMethod && hasStaticCopyMethod;
    }
}

