/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.keycloak.pep.runtime.DefaultPolicyEnforcerResolver;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerAuthorizer;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerBuildTimeConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerRecorder;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import java.util.function.BooleanSupplier;

@BuildSteps(onlyIf={IsEnabled.class})
public class KeycloakPolicyEnforcerBuildStep {
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    RequireBodyHandlerBuildItem requireBody(OidcBuildTimeConfig oidcBuildTimeConfig, KeycloakPolicyEnforcerRecorder recorder) {
        if (oidcBuildTimeConfig.enabled()) {
            return new RequireBodyHandlerBuildItem(recorder.createBodyHandlerRequiredEvaluator());
        }
        return null;
    }

    @BuildStep
    public AdditionalBeanBuildItem beans(OidcBuildTimeConfig oidcBuildTimeConfig) {
        if (oidcBuildTimeConfig.enabled()) {
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(KeycloakPolicyEnforcerAuthorizer.class).addBeanClass(DefaultPolicyEnforcerResolver.class).build();
        }
        return null;
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.KEYCLOAK_AUTHORIZATION);
    }

    public static class IsEnabled
    implements BooleanSupplier {
        KeycloakPolicyEnforcerBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.policyEnforcer().enable();
        }
    }
}

