/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.admin.rest.client.runtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.ClientJacksonMessageBodyWriter;
import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.reactive.client.TlsConfig;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.server.jackson.JacksonBasicMessageBodyReader;
import org.keycloak.admin.client.spi.ResteasyClientProvider;

public class KeycloakAdminRestClientProvider
implements ResteasyClientProvider {
    private static final List<String> HANDLED_MEDIA_TYPES = List.of("application/json");
    private static final int WRITER_PROVIDER_PRIORITY = 5100;
    private static final int READER_PROVIDER_PRIORITY = 4900;
    private final boolean tlsTrustAll;
    private final TlsConfig tlsConfig;

    public KeycloakAdminRestClientProvider(boolean tlsTrustAll) {
        this.tlsTrustAll = tlsTrustAll;
        this.tlsConfig = null;
    }

    public KeycloakAdminRestClientProvider(TlsConfiguration tlsConfiguration) {
        this.tlsTrustAll = tlsConfiguration.isTrustAll();
        this.tlsConfig = KeycloakAdminRestClientProvider.createTlsConfig(tlsConfiguration);
    }

    public Client newRestEasyClient(Object messageHandler, SSLContext sslContext, boolean disableTrustManager) {
        ClientBuilderImpl clientBuilder = new ClientBuilderImpl();
        if (this.tlsConfig == null) {
            clientBuilder.trustAll(this.tlsTrustAll || disableTrustManager);
        } else {
            clientBuilder.tlsConfig(this.tlsConfig);
        }
        return this.registerJacksonProviders(clientBuilder).build();
    }

    private ClientBuilderImpl registerJacksonProviders(ClientBuilderImpl clientBuilder) {
        ArcContainer arcContainer = Arc.container();
        if (arcContainer == null) {
            throw new IllegalStateException(this.getClass().getName() + " should only be used in a Quarkus application");
        }
        ObjectMapper newObjectMapper = this.newKeycloakAdminClientObjectMapper();
        clientBuilder = clientBuilder.registerMessageBodyReader((MessageBodyReader)new JacksonBasicMessageBodyReader(newObjectMapper), Object.class, HANDLED_MEDIA_TYPES, true, Integer.valueOf(4900)).registerMessageBodyWriter((MessageBodyWriter)new ClientJacksonMessageBodyWriter(newObjectMapper), Object.class, HANDLED_MEDIA_TYPES, true, Integer.valueOf(5100));
        InstanceHandle clientLogger = arcContainer.instance(ClientLogger.class, new Annotation[0]);
        if (clientLogger.isAvailable()) {
            clientBuilder.clientLogger((ClientLogger)clientLogger.get());
        }
        return clientBuilder;
    }

    private ObjectMapper newKeycloakAdminClientObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public <R> R targetProxy(WebTarget target, Class<R> targetClass) {
        return (R)((WebTargetImpl)target).proxy(targetClass);
    }

    private static TlsConfig createTlsConfig(final TlsConfiguration tlsConfiguration) {
        return new TlsConfig(){

            public KeyStore getKeyStore() {
                return tlsConfiguration.getKeyStore();
            }

            public KeyCertOptions getKeyStoreOptions() {
                return tlsConfiguration.getKeyStoreOptions();
            }

            public KeyStore getTrustStore() {
                return tlsConfiguration.getTrustStore();
            }

            public TrustOptions getTrustStoreOptions() {
                return tlsConfiguration.getTrustStoreOptions();
            }

            public SSLOptions getSSLOptions() {
                return tlsConfiguration.getSSLOptions();
            }

            public SSLContext createSSLContext() throws Exception {
                return tlsConfiguration.createSSLContext();
            }

            public Optional<String> getHostnameVerificationAlgorithm() {
                return tlsConfiguration.getHostnameVerificationAlgorithm();
            }

            public boolean usesSni() {
                return tlsConfiguration.usesSni();
            }

            public boolean isTrustAll() {
                return tlsConfiguration.isTrustAll();
            }

            public Optional<String> getName() {
                return Optional.ofNullable(tlsConfiguration.getName());
            }
        };
    }
}

