/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime.devui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

final class TopologyParserContext {
    String currentNode = "";
    final Set<String> subTopologies = new TreeSet<String>();
    final Set<String> sources = new TreeSet<String>();
    final Set<String> sinks = new TreeSet<String>();
    final Set<String> stores = new TreeSet<String>();
    final Graphviz graphviz = new Graphviz();
    final Mermaid mermaid = new Mermaid();

    TopologyParserContext() {
    }

    void addSubTopology(String subTopology) {
        String sanitizedSubTopology = TopologyParserContext.sanitize(subTopology);
        this.subTopologies.add(sanitizedSubTopology);
        this.graphviz.addSubTopology(sanitizedSubTopology);
        this.mermaid.addSubTopology(sanitizedSubTopology);
    }

    void addSink(String sink, String topic) {
        String sanitizedTopic = TopologyParserContext.sanitize(topic);
        this.sinks.add(sanitizedTopic);
        String sanitizedSink = TopologyParserContext.sanitize(sink);
        this.currentNode = TopologyParserContext.sanitize(sanitizedSink);
        this.graphviz.addSink(sanitizedSink, sanitizedTopic);
        this.mermaid.addSink(sanitizedSink, sanitizedTopic);
    }

    void addSources(String source, String[] topics) {
        this.currentNode = TopologyParserContext.sanitize(source);
        Arrays.stream(topics).map(String::trim).filter(topic -> !topic.isEmpty()).forEachOrdered(topic -> {
            String sanitizedTopic = TopologyParserContext.sanitize(topic);
            this.sources.add(sanitizedTopic);
            this.graphviz.addSource(this.currentNode, sanitizedTopic);
            this.mermaid.addSource(this.currentNode, sanitizedTopic);
        });
    }

    void addRegexSource(String source, String regex) {
        this.currentNode = TopologyParserContext.sanitize(source);
        String sanitizedRegex = TopologyParserContext.sanitize(regex);
        if (!sanitizedRegex.isEmpty()) {
            this.sources.add(sanitizedRegex);
            this.graphviz.addRegexSource(this.currentNode, sanitizedRegex);
            this.mermaid.addRegexSource(this.currentNode, sanitizedRegex);
        }
    }

    void addStores(String[] stores, String processor, boolean join) {
        this.currentNode = TopologyParserContext.sanitize(processor);
        Arrays.stream(stores).map(String::trim).filter(store -> !store.isEmpty()).forEachOrdered(store -> {
            String sanitizedStore = TopologyParserContext.sanitize(store);
            this.stores.add(sanitizedStore);
            this.graphviz.addStore(sanitizedStore, this.currentNode, join);
            this.mermaid.addStore(sanitizedStore, this.currentNode, join);
        });
    }

    void addTargets(String[] targets) {
        Arrays.stream(targets).map(String::trim).filter(target -> !"none".equals(target) && !target.isEmpty()).forEachOrdered(target -> {
            String sanitizedTarget = TopologyParserContext.sanitize(target);
            this.graphviz.addTarget(sanitizedTarget, this.currentNode);
            this.mermaid.addTarget(sanitizedTarget, this.currentNode);
        });
    }

    private static String sanitize(String name) {
        return name != null ? name.trim().replaceAll("\"", "") : null;
    }

    static final class Graphviz {
        String currentGraph = "";
        final List<String> nodes = new ArrayList<String>();
        final List<String> edges = new ArrayList<String>();
        final Map<String, List<String>> subGraphs = new TreeMap<String, List<String>>();

        Graphviz() {
        }

        String toGraph() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("digraph {");
            res.add(" fontname=Helvetica; fontsize=10;");
            res.add(" node [style=filled fillcolor=white color=\"#C9B7DD\" shape=box fontname=Helvetica fontsize=10];");
            this.nodes.forEach(n -> res.add(" " + n + ";"));
            this.subGraphs.entrySet().forEach(e -> {
                res.add(" subgraph cluster" + (String)e.getKey() + " {");
                res.add("  label=\"Sub-Topology: " + (String)e.getKey() + "\"; color=\"#C8C879\"; bgcolor=\"#FFFFDE\";");
                ((List)e.getValue()).forEach(v -> res.add("  " + v + ";"));
                res.add(" }");
            });
            this.edges.forEach(e -> res.add(" " + e + ";"));
            res.add("}");
            return String.join((CharSequence)"\n", res);
        }

        private void addSubTopology(String subTopology) {
            this.currentGraph = subTopology;
            this.subGraphs.put(subTopology, new ArrayList());
        }

        private void addSink(String sink, String topic) {
            this.nodes.add(Graphviz.toId(topic) + " [label=\"" + Graphviz.toLabel(topic) + "\" shape=house margin=\"0,0\"]");
            this.edges.add(Graphviz.toId(sink) + " -> " + Graphviz.toId(topic));
        }

        private void addSource(String source, String topic) {
            this.nodes.add(Graphviz.toId(topic) + " [label=\"" + Graphviz.toLabel(topic) + "\" shape=invhouse margin=\"0,0\"]");
            this.nodes.add(Graphviz.toId(source) + " [label=\"" + Graphviz.toLabel(source) + "\"]");
            this.edges.add(Graphviz.toId(topic) + " -> " + Graphviz.toId(source));
            this.subGraphs.get(this.currentGraph).add(Graphviz.toId(source));
        }

        private void addRegexSource(String source, String regex) {
            String regexId = "REGEX_" + this.nodes.size();
            String regexLabel = regex.replaceAll("\\\\", "\\\\\\\\");
            this.nodes.add(regexId + " [label=\"" + regexLabel + "\" shape=invhouse style=dashed margin=\"0,0\"]");
            this.nodes.add(Graphviz.toId(source) + " [label=\"" + Graphviz.toLabel(source) + "\"]");
            this.edges.add(regexId + " -> " + Graphviz.toId(source));
            this.subGraphs.get(this.currentGraph).add(Graphviz.toId(source));
        }

        private void addTarget(String target, String node) {
            this.nodes.add(Graphviz.toId(target) + " [label=\"" + Graphviz.toLabel(target) + "\"]");
            this.edges.add(Graphviz.toId(node) + " -> " + Graphviz.toId(target));
            this.subGraphs.get(this.currentGraph).add(Graphviz.toId(target));
        }

        private void addStore(String store, String node, boolean join) {
            this.nodes.add(Graphviz.toId(store) + " [label=\"" + Graphviz.toLabel(store) + "\" shape=cylinder]");
            if (join) {
                this.edges.add(Graphviz.toId(store) + " -> " + Graphviz.toId(node));
            } else {
                this.edges.add(Graphviz.toId(node) + " -> " + Graphviz.toId(store));
            }
        }

        private static String toId(String name) {
            return "\"" + name + "\"";
        }

        private static String toLabel(String name) {
            return name.replaceAll("-", "\\\\n");
        }
    }

    static final class Mermaid {
        final List<String> endpoints = new ArrayList<String>();
        final List<String> subTopologies = new ArrayList<String>();

        Mermaid() {
        }

        String toGraph() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("graph TD");
            this.endpoints.forEach(e -> res.add(" " + e));
            this.subTopologies.forEach(s -> res.add(" " + s));
            if (!this.subTopologies.isEmpty()) {
                res.add(" end");
            }
            return String.join((CharSequence)"\n", res);
        }

        private void addSubTopology(String subTopology) {
            if (!this.subTopologies.isEmpty()) {
                this.subTopologies.add("end");
            }
            this.subTopologies.add("subgraph Sub-Topology: " + subTopology);
        }

        private void addSink(String sink, String topic) {
            this.endpoints.add(sink + "[" + Mermaid.toName(sink) + "] --> " + topic + "(" + topic + ")");
        }

        private void addSource(String source, String topic) {
            this.endpoints.add(topic + "[" + topic + "] --> " + source + "(" + Mermaid.toName(source) + ")");
        }

        private void addRegexSource(String source, String regex) {
            this.endpoints.add("REGEX_" + this.endpoints.size() + "[" + regex + "] --> " + source + "(" + Mermaid.toName(source) + ")");
        }

        private void addTarget(String target, String node) {
            this.subTopologies.add(" " + node + "[" + Mermaid.toName(node) + "] --> " + target + "(" + Mermaid.toName(target) + ")");
        }

        private void addStore(String store, String node, boolean join) {
            if (join) {
                this.endpoints.add(store + "[" + Mermaid.toName(store) + "] --> " + node + "(" + Mermaid.toName(node) + ")");
            } else {
                this.endpoints.add(node + "[" + Mermaid.toName(node) + "] --> " + store + "(" + Mermaid.toName(store) + ")");
            }
        }

        private static String toName(String name) {
            return name.replaceAll("-", "-<br>");
        }
    }
}

