/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.jboss.logging.Logger;

public class KafkaStreamsTopologyManager {
    private static final Logger LOGGER = Logger.getLogger((String)KafkaStreamsTopologyManager.class.getName());
    private final Admin adminClient;

    public KafkaStreamsTopologyManager(Admin adminClient) {
        this.adminClient = adminClient;
    }

    public Set<String> getMissingTopics(Collection<String> topicsToCheck) throws InterruptedException {
        return this.getMissingTopics(topicsToCheck, Duration.ofSeconds(10L));
    }

    public Set<String> getMissingTopics(Collection<String> topicsToCheck, Duration timeout) throws InterruptedException {
        LinkedHashSet<String> missing = new LinkedHashSet<String>(topicsToCheck);
        try {
            ListTopicsResult topics = this.adminClient.listTopics();
            Set topicNames = (Set)topics.names().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (topicNames.containsAll(topicsToCheck)) {
                return Collections.emptySet();
            }
            missing.removeAll(topicNames);
        }
        catch (ExecutionException | TimeoutException e) {
            LOGGER.error((Object)"Failed to get topic names from broker", (Throwable)e);
        }
        return missing;
    }
}

