/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.streams.runtime.devui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

final class TopologyParserContext {
    String currentNode = "";
    final Set<String> subTopologies = new TreeSet<String>();
    final Set<String> sources = new TreeSet<String>();
    final Set<String> sinks = new TreeSet<String>();
    final Set<String> stores = new TreeSet<String>();
    final Graphviz graphviz = new Graphviz();
    final Mermaid mermaid = new Mermaid();

    TopologyParserContext() {
    }

    void addSubTopology(String subTopology) {
        this.subTopologies.add(subTopology);
        this.graphviz.addSubTopology(subTopology);
        this.mermaid.addSubTopology(subTopology);
    }

    void addSink(String sink, String topic) {
        this.sinks.add(topic);
        this.currentNode = sink;
        this.graphviz.addSink(sink, topic);
        this.mermaid.addSink(sink, topic);
    }

    void addSources(String source, String[] topics) {
        this.currentNode = source;
        Arrays.stream(topics).map(String::trim).filter(topic -> !topic.isEmpty()).forEachOrdered(topic -> {
            this.sources.add((String)topic);
            this.graphviz.addSource(source, (String)topic);
            this.mermaid.addSource(source, (String)topic);
        });
    }

    void addRegexSource(String source, String regex) {
        this.currentNode = source;
        String cleanRegex = regex.trim();
        if (!cleanRegex.isEmpty()) {
            this.sources.add(cleanRegex);
            this.graphviz.addRegexSource(source, cleanRegex);
            this.mermaid.addRegexSource(source, cleanRegex);
        }
    }

    void addStores(String[] stores, String processor, boolean join) {
        this.currentNode = processor;
        Arrays.stream(stores).map(String::trim).filter(store -> !store.isEmpty()).forEachOrdered(store -> {
            this.stores.add((String)store);
            this.graphviz.addStore((String)store, this.currentNode, join);
            this.mermaid.addStore((String)store, this.currentNode, join);
        });
    }

    void addTargets(String[] targets) {
        Arrays.stream(targets).map(String::trim).filter(target -> !"none".equals(target) && !target.isEmpty()).forEachOrdered(target -> {
            this.graphviz.addTarget((String)target, this.currentNode);
            this.mermaid.addTarget((String)target, this.currentNode);
        });
    }

    static final class Graphviz {
        String currentGraph = "";
        final List<String> nodes = new ArrayList<String>();
        final List<String> edges = new ArrayList<String>();
        final Map<String, List<String>> subGraphs = new TreeMap<String, List<String>>();

        Graphviz() {
        }

        String toGraph() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("digraph {");
            res.add(" fontname=Helvetica; fontsize=10;");
            res.add(" node [style=filled fillcolor=white color=\"#C9B7DD\" shape=box fontname=Helvetica fontsize=10];");
            this.nodes.forEach(n -> res.add(" " + n + ";"));
            this.subGraphs.entrySet().forEach(e -> {
                res.add(" subgraph cluster" + (String)e.getKey() + " {");
                res.add("  label=\"Sub-Topology: " + (String)e.getKey() + "\"; color=\"#C8C879\"; bgcolor=\"#FFFFDE\";");
                ((List)e.getValue()).forEach(v -> res.add("  " + v + ";"));
                res.add(" }");
            });
            this.edges.forEach(e -> res.add(" " + e + ";"));
            res.add("}");
            return String.join((CharSequence)"\n", res);
        }

        private void addSubTopology(String subTopology) {
            this.currentGraph = subTopology;
            this.subGraphs.put(subTopology, new ArrayList());
        }

        private void addSink(String sink, String topic) {
            this.nodes.add(Graphviz.toId(topic) + " [label=\"" + Graphviz.toLabel(topic) + "\" shape=house margin=\"0,0\"]");
            this.edges.add(Graphviz.toId(sink) + " -> " + Graphviz.toId(topic));
        }

        private void addSource(String source, String topic) {
            this.nodes.add(Graphviz.toId(topic) + " [label=\"" + Graphviz.toLabel(topic) + "\" shape=invhouse margin=\"0,0\"]");
            this.nodes.add(Graphviz.toId(source) + " [label=\"" + Graphviz.toLabel(source) + "\"]");
            this.edges.add(Graphviz.toId(topic) + " -> " + Graphviz.toId(source));
            this.subGraphs.get(this.currentGraph).add(Graphviz.toId(source));
        }

        private void addRegexSource(String source, String regex) {
            String regexId = "REGEX_" + this.nodes.size();
            String regexLabel = regex.replaceAll("\\\\", "\\\\\\\\");
            this.nodes.add(regexId + " [label=\"" + regexLabel + "\" shape=invhouse style=dashed margin=\"0,0\"]");
            this.nodes.add(Graphviz.toId(source) + " [label=\"" + Graphviz.toLabel(source) + "\"]");
            this.edges.add(regexId + " -> " + Graphviz.toId(source));
            this.subGraphs.get(this.currentGraph).add(Graphviz.toId(source));
        }

        private void addTarget(String target, String node) {
            this.nodes.add(Graphviz.toId(target) + " [label=\"" + Graphviz.toLabel(target) + "\"]");
            this.edges.add(Graphviz.toId(node) + " -> " + Graphviz.toId(target));
            this.subGraphs.get(this.currentGraph).add(Graphviz.toId(target));
        }

        private void addStore(String store, String node, boolean join) {
            this.nodes.add(Graphviz.toId(store) + " [label=\"" + Graphviz.toLabel(store) + "\" shape=cylinder]");
            if (join) {
                this.edges.add(Graphviz.toId(store) + " -> " + Graphviz.toId(node));
            } else {
                this.edges.add(Graphviz.toId(node) + " -> " + Graphviz.toId(store));
            }
        }

        private static String toId(String name) {
            return name.replaceAll("-", "_");
        }

        private static String toLabel(String name) {
            return name.replaceAll("-", "\\\\n");
        }
    }

    static final class Mermaid {
        final List<String> endpoints = new ArrayList<String>();
        final List<String> subTopologies = new ArrayList<String>();

        Mermaid() {
        }

        String toGraph() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("graph TD");
            this.endpoints.forEach(e -> res.add(" " + e));
            this.subTopologies.forEach(s -> res.add(" " + s));
            if (!this.subTopologies.isEmpty()) {
                res.add(" end");
            }
            return String.join((CharSequence)"\n", res);
        }

        private void addSubTopology(String subTopology) {
            if (!this.subTopologies.isEmpty()) {
                this.subTopologies.add("end");
            }
            this.subTopologies.add("subgraph Sub-Topology: " + subTopology);
        }

        private void addSink(String sink, String topic) {
            this.endpoints.add(sink + "[" + Mermaid.toName(sink) + "] --> " + topic + "(" + topic + ")");
        }

        private void addSource(String source, String topic) {
            this.endpoints.add(topic + "[" + topic + "] --> " + source + "(" + Mermaid.toName(source) + ")");
        }

        private void addRegexSource(String source, String regex) {
            this.endpoints.add("REGEX_" + this.endpoints.size() + "[" + regex + "] --> " + source + "(" + Mermaid.toName(source) + ")");
        }

        private void addTarget(String target, String node) {
            this.subTopologies.add(" " + node + "[" + Mermaid.toName(node) + "] --> " + target + "(" + Mermaid.toName(target) + ")");
        }

        private void addStore(String store, String node, boolean join) {
            if (join) {
                this.endpoints.add(store + "[" + Mermaid.toName(store) + "] --> " + node + "(" + Mermaid.toName(node) + ")");
            } else {
                this.endpoints.add(node + "[" + Mermaid.toName(node) + "] --> " + store + "(" + Mermaid.toName(store) + ")");
            }
        }

        private static String toName(String name) {
            return name.replaceAll("-", "-<br>");
        }
    }
}

