/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.dev.ui;

import io.quarkus.kafka.client.runtime.KafkaAdminClient;
import io.quarkus.kafka.client.runtime.KafkaCreateTopicRequest;
import io.quarkus.kafka.client.runtime.dev.ui.KafkaUiUtils;
import io.quarkus.kafka.client.runtime.dev.ui.model.Order;
import io.quarkus.kafka.client.runtime.dev.ui.model.request.KafkaMessageCreateRequest;
import io.quarkus.kafka.client.runtime.dev.ui.model.request.KafkaMessagesRequest;
import io.quarkus.kafka.client.runtime.dev.ui.model.request.KafkaOffsetRequest;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaAclInfo;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaInfo;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaMessagePage;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaTopic;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class KafkaJsonRPCService {
    @Inject
    KafkaUiUtils kafkaUiUtils;
    @Inject
    KafkaAdminClient kafkaAdminClient;

    public List<KafkaTopic> getTopics() throws InterruptedException, ExecutionException {
        return this.kafkaUiUtils.getTopics();
    }

    public List<KafkaTopic> createTopic(String topicName, int partitions, int replications, Map<String, String> configs) throws InterruptedException, ExecutionException {
        KafkaCreateTopicRequest createTopicRequest = new KafkaCreateTopicRequest(topicName, Integer.valueOf(partitions), Short.valueOf((short)replications), configs);
        boolean created = this.kafkaAdminClient.createTopic(createTopicRequest);
        if (created) {
            return this.kafkaUiUtils.getTopics();
        }
        throw new RuntimeException("Topic [" + topicName + "] not created");
    }

    public List<KafkaTopic> deleteTopic(String topicName) throws InterruptedException, ExecutionException {
        boolean deleted = this.kafkaAdminClient.deleteTopic(topicName);
        if (deleted) {
            return this.kafkaUiUtils.getTopics();
        }
        throw new RuntimeException("Topic [" + topicName + "] not deleted");
    }

    public KafkaMessagePage topicMessages(String topicName) throws ExecutionException, InterruptedException {
        List<Integer> partitions = this.getPartitions(topicName);
        KafkaOffsetRequest offsetRequest = new KafkaOffsetRequest(topicName, partitions, Order.NEW_FIRST);
        Map<Integer, Long> offset = this.kafkaUiUtils.getOffset(offsetRequest);
        KafkaMessagesRequest request = new KafkaMessagesRequest(topicName, Order.NEW_FIRST, 20, offset);
        return this.kafkaUiUtils.getMessages(request);
    }

    public KafkaMessagePage createMessage(String topicName, Integer partition, String key, String value, Map<String, String> headers) throws ExecutionException, InterruptedException {
        if (partition < 0) {
            partition = null;
        }
        KafkaMessageCreateRequest request = new KafkaMessageCreateRequest(topicName, partition, value, key, headers);
        this.kafkaUiUtils.createMessage(request);
        return this.topicMessages(topicName);
    }

    public List<Integer> getPartitions(String topicName) throws ExecutionException, InterruptedException {
        return new ArrayList<Integer>(this.kafkaUiUtils.partitions(topicName));
    }

    public KafkaInfo getInfo() throws ExecutionException, InterruptedException {
        return this.kafkaUiUtils.getKafkaInfo();
    }

    public KafkaAclInfo getAclInfo() throws InterruptedException, ExecutionException {
        return this.kafkaUiUtils.getAclInfo();
    }
}

