/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import io.quarkus.kafka.client.deployment.RedpandaBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public interface KafkaDevServicesBuildTimeConfig {
    public Optional<Boolean> enabled();

    public Optional<Integer> port();

    @WithDefault(value="redpanda")
    public Provider provider();

    public Optional<String> imageName();

    @WithDefault(value="true")
    public boolean shared();

    @WithDefault(value="kafka")
    public String serviceName();

    @ConfigDocMapKey(value="topic-name")
    public Map<String, Integer> topicPartitions();

    @WithDefault(value="2S")
    public Duration topicPartitionsTimeout();

    @ConfigDocMapKey(value="environment-variable-name")
    public Map<String, String> containerEnv();

    public RedpandaBuildTimeConfig redpanda();

    default public String effectiveImageName() {
        return this.imageName().orElseGet(() -> this.provider().getDefaultImageName());
    }

    public static enum Provider {
        REDPANDA("docker.io/redpandadata/redpanda:v24.1.2"),
        STRIMZI("quay.io/strimzi-test-container/test-container:latest-kafka-3.7.0"),
        KAFKA_NATIVE("quay.io/ogunalp/kafka-native:latest");

        private final String defaultImageName;

        private Provider(String imageName) {
            this.defaultImageName = imageName;
        }

        public String getDefaultImageName() {
            return this.defaultImageName;
        }
    }
}

