/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment.devui;

import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.kafka.client.runtime.dev.ui.KafkaJsonRPCService;
import org.jboss.logging.Logger;

public class KafkaDevUIProcessor {
    private static final Logger log = Logger.getLogger(KafkaDevUIProcessor.class);

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    public CardPageBuildItem pages() {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.setLogo("kafka_dark.png", "kafka_light.png");
        cardPageBuildItem.addLibraryVersion("org.apache.kafka", "kafka-clients", "Apache Kafka", "https://kafka.apache.org/");
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:folder-tree")).componentLink("qwc-kafka-topics.js").title("Topics"));
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:inbox")).componentLink("qwc-kafka-consumer-groups.js").title("Consumer groups"));
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:key")).componentLink("qwc-kafka-access-control-list.js").title("Access control list"));
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:circle-nodes")).componentLink("qwc-kafka-nodes.js").title("Nodes"));
        return cardPageBuildItem;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(KafkaJsonRPCService.class);
    }
}

